/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;

public class EntityDeathScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityDeathScriptEvent instance;
    public EntityTag entity;
    public EntityTag damager;
    public ElementTag cause;
    public EntityDeathEvent event;

    public EntityDeathScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        String cmd = path.eventArgLowerAt(1);
        if (!cmd.equals("dies") && !cmd.equals("death")) {
            return false;
        }
        return this.couldMatchEntity(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target = path.eventArgLowerAt(0);
        if (!EntityDeathScriptEvent.tryEntity(this.entity, target)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        if (path.switches.containsKey("by") && (this.damager == null || !EntityDeathScriptEvent.tryEntity(this.damager, path.switches.get("by")))) {
            return false;
        }
        if (!EntityDeathScriptEvent.runGenericSwitchCheck(path, "cause", this.cause == null ? null : this.cause.asString())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "EntityDies";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        String lower = CoreUtilities.toLowerCase(determination);
        if (lower.startsWith("drops ")) {
            lower = lower.substring(6);
            determination = determination.substring(6);
        }
        if (lower.startsWith("no_drops")) {
            this.event.getDrops().clear();
            if (lower.endsWith("_or_xp")) {
                this.event.setDroppedExp(0);
            }
            return true;
        }
        if (lower.equals("no_xp")) {
            this.event.setDroppedExp(0);
            return true;
        }
        if (lower.equals("keep_inv") && this.event instanceof PlayerDeathEvent) {
            ((PlayerDeathEvent)this.event).setKeepInventory(true);
            return true;
        }
        if (lower.equals("keep_level") && this.event instanceof PlayerDeathEvent) {
            ((PlayerDeathEvent)this.event).setKeepLevel(true);
            return true;
        }
        if (lower.equals("no_message") && this.event instanceof PlayerDeathEvent) {
            ((PlayerDeathEvent)this.event).setDeathMessage(null);
            return true;
        }
        if (determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isInt()) {
            this.event.setDroppedExp(((ElementTag)determinationObj).asInt());
            return true;
        }
        if (Argument.valueOf(lower).matchesArgumentList(ItemTag.class)) {
            List drops = this.event.getDrops();
            drops.clear();
            for (ItemTag item : ListTag.getListFor(determinationObj, this.getTagContext(path)).filter(ItemTag.class, this.getTagContext(path), true)) {
                if (item == null) continue;
                drops.add(item.getItemStack());
            }
            return true;
        }
        if (this.event instanceof PlayerDeathEvent) {
            ((PlayerDeathEvent)this.event).setDeathMessage(determination);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("damager") && this.damager != null) {
            return this.damager.getDenizenObject();
        }
        if (name.equals("message") && this.event instanceof PlayerDeathEvent) {
            return new ElementTag(((PlayerDeathEvent)this.event).getDeathMessage());
        }
        if (name.equals("cause") && this.cause != null) {
            return this.cause;
        }
        if (name.equals("drops")) {
            ListTag list = new ListTag();
            for (ItemStack stack : this.event.getDrops()) {
                list.addObject(new ItemTag(stack));
            }
            return list;
        }
        if (name.equals("xp")) {
            return new ElementTag(this.event.getDroppedExp());
        }
        return super.getContext(name);
    }

    @Override
    public void cancellationChanged() {
        if (this.cancelled && this.event instanceof PlayerDeathEvent) {
            ((PlayerDeathEvent)this.event).setDeathMessage(null);
        }
        super.cancellationChanged();
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        EntityTag.rememberEntity((Entity)livingEntity);
        this.entity = new EntityTag((Entity)livingEntity);
        this.cause = null;
        this.damager = null;
        EntityDamageEvent lastDamage = this.entity.getBukkitEntity().getLastDamageCause();
        if (lastDamage != null) {
            this.cause = new ElementTag(event.getEntity().getLastDamageCause().getCause().toString());
            if (lastDamage instanceof EntityDamageByEntityEvent) {
                EntityTag damageEntity = new EntityTag(((EntityDamageByEntityEvent)lastDamage).getDamager());
                EntityTag shooter = damageEntity.getShooter();
                this.damager = shooter != null ? shooter : damageEntity;
            } else if (livingEntity.getKiller() != null) {
                this.damager = new EntityTag((Entity)livingEntity.getKiller());
            }
        }
        this.cancelled = false;
        this.event = event;
        this.fire((Event)event);
        EntityTag.forgetEntity((Entity)livingEntity);
    }
}

