/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.events.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import java.util.Calendar;

public class SystemTimeScriptEvent
extends ScriptEvent {
    public static SystemTimeScriptEvent instance;
    public ElementTag hour;
    public ScriptEntryData data = null;
    public ElementTag minute;
    public long seconds;
    boolean enab = false;
    int lH = 0;
    int lM = 0;
    long lS = 0L;
    boolean minuteChanged = true;

    public SystemTimeScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("system time");
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return this.data;
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        int count;
        String time = path.rawEventArgAt(2);
        String countString = path.switches.get("every");
        int n = count = countString == null ? 1 : Integer.parseInt(countString);
        if (time.equals("secondly")) {
            if (this.seconds % (long)count != 0L) {
                return false;
            }
        } else if (time.equals("minutely")) {
            if (!this.minuteChanged) {
                return false;
            }
            long minutes = this.seconds / 60L;
            if (minutes % (long)count != 0L) {
                return false;
            }
        } else if (time.equals("hourly")) {
            if (!this.minuteChanged || this.lM != 0) {
                return false;
            }
            long hours = this.seconds / 3600L;
            if (hours % (long)count != 0L) {
                return false;
            }
        } else if (!this.minuteChanged || !time.equals(this.hour.asString() + ":" + this.minute.asString())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "SystemTime";
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "hour": {
                return this.hour;
            }
            case "minute": {
                return this.minute;
            }
        }
        return super.getContext(name);
    }

    @Override
    public void init() {
        this.enab = true;
    }

    @Override
    public void destroy() {
        this.enab = false;
    }

    public void checkTime() {
        if (!this.enab) {
            return;
        }
        this.seconds = System.currentTimeMillis() / 1000L;
        if (this.lS == this.seconds) {
            return;
        }
        this.lS = this.seconds;
        Calendar calendar = Calendar.getInstance();
        int h = calendar.get(11);
        int m = calendar.get(12);
        this.minuteChanged = this.lH != h || this.lM != m;
        this.lH = h;
        this.lM = m;
        this.hour = h < 10 ? new ElementTag("0" + h) : new ElementTag(h);
        this.minute = m < 10 ? new ElementTag("0" + m) : new ElementTag(m);
        this.data = DenizenCore.implementation.getEmptyScriptEntryData();
        this.fire();
    }
}

