/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.plugin.Plugin;

public class InventoryPicksUpItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static InventoryPicksUpItemScriptEvent instance;
    public dInventory inventory;
    public dItem item;
    public dEntity entity;
    public InventoryPickupItemEvent event;

    public InventoryPicksUpItemScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.contains("picks up") && !lower.startsWith("player");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String s = path.event;
        String lower = path.eventLower;
        String inv = CoreUtilities.getXthArg(0, lower);
        String itemName = CoreUtilities.getXthArg(3, lower);
        if (!inv.equals("inventory") && !inv.equals(CoreUtilities.toLowerCase(this.inventory.getInventoryType().toString()))) {
            return false;
        }
        return itemName.equals("item") || this.tryItem(this.item, itemName);
    }

    @Override
    public String getName() {
        return "InventoryPicksUpItem";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        InventoryPickupItemEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("inventory")) {
            return this.inventory;
        }
        if (name.equals("entity")) {
            return this.entity;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onInvPicksUpItem(InventoryPickupItemEvent event) {
        this.inventory = dInventory.mirrorBukkitInventory(event.getInventory());
        this.item = new dItem(event.getItem());
        this.entity = new dEntity((Entity)event.getItem());
        this.cancelled = event.isCancelled();
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

