/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.impl.blocks;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.abstracts.BlockLight;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.Entity;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.EnumSkyBlock;
import net.minecraft.server.v1_12_R1.IBlockData;
import net.minecraft.server.v1_12_R1.IWorldAccess;
import net.minecraft.server.v1_12_R1.PlayerChunkMap;
import net.minecraft.server.v1_12_R1.SoundCategory;
import net.minecraft.server.v1_12_R1.SoundEffect;
import net.minecraft.server.v1_12_R1.WorldServer;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BlockLight_v1_12_R1
extends BlockLight {
    private static final Method playerChunkMethod;
    private static final Field dirtyCountField;
    private static final BukkitTask bukkitTask;
    private static final Set<UUID> worlds;
    private final CraftWorld craftWorld;
    private final WorldServer worldServer;
    private final BlockPosition position;

    private BlockLight_v1_12_R1(Location location, long ticks) {
        super(location, ticks);
        this.craftWorld = (CraftWorld)location.getWorld();
        this.worldServer = this.craftWorld.getHandle();
        if (!worlds.contains(this.craftWorld.getUID())) {
            IWorldAccess access = BlockLight_v1_12_R1.getIWorldAccess((World)this.craftWorld);
            this.worldServer.addIWorldAccess(access);
            worlds.add(this.craftWorld.getUID());
        }
        this.position = new BlockPosition(this.block.getX(), this.block.getY(), this.block.getZ());
    }

    public static BlockLight createLight(Location location, int lightLevel, long ticks) {
        BlockLight blockLight;
        if (lightsByLocation.containsKey(location = location.getBlock().getLocation())) {
            blockLight = (BlockLight)lightsByLocation.get(location);
            if (blockLight.removeTask != null) {
                blockLight.removeTask.cancel();
                blockLight.removeTask = null;
            }
            blockLight.reset(true);
            blockLight.removeLater(ticks);
        } else {
            blockLight = new BlockLight_v1_12_R1(location, ticks);
            lightsByLocation.put(location, blockLight);
            if (!lightsByChunk.containsKey(blockLight.chunk)) {
                lightsByChunk.put(blockLight.chunk, new ArrayList());
            }
            ((List)lightsByChunk.get(blockLight.chunk)).add(blockLight);
        }
        blockLight.update(lightLevel, true);
        return blockLight;
    }

    @Override
    public void update(int lightLevel, boolean updateChunk) {
        if (this.currentLight == lightLevel) {
            return;
        }
        if (this.originalLight == lightLevel) {
            this.worldServer.c(EnumSkyBlock.BLOCK, this.position);
        } else {
            this.worldServer.a(EnumSkyBlock.BLOCK, this.position, lightLevel);
            Block adjacentAir = null;
            for (BlockFace face : adjacentFaces) {
                Block possible;
                if (this.position.getY() == 0 && face == BlockFace.DOWN || this.position.getY() == this.craftWorld.getMaxHeight() - 1 && face == BlockFace.UP || (possible = this.block.getRelative(face)).getType() != Material.AIR) continue;
                adjacentAir = possible;
                break;
            }
            if (adjacentAir != null) {
                this.worldServer.w(new BlockPosition(adjacentAir.getX(), adjacentAir.getY(), adjacentAir.getZ()));
            }
            this.cachedLight = lightLevel;
        }
        if (updateChunk) {
            BlockLight_v1_12_R1.updateChunk(this.chunk, this.worldServer.getPlayerChunkMap());
        }
        this.currentLight = lightLevel;
    }

    private static void updateChunk(Chunk chunk, PlayerChunkMap playerChunkMap) {
        int cX = chunk.getX();
        int cZ = chunk.getZ();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                Object pChunk = BlockLight_v1_12_R1.getPlayerChunk(playerChunkMap, cX + x, cZ + z);
                if (pChunk == null) continue;
                BlockLight_v1_12_R1.setDirtyCount(pChunk);
            }
        }
    }

    private static Object getPlayerChunk(PlayerChunkMap map, int x, int z) {
        try {
            return playerChunkMethod.invoke((Object)map, x, z);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void setDirtyCount(Object playerChunk) {
        try {
            int dirtyCount = dirtyCountField.getInt(playerChunk);
            if (dirtyCount > 0 && dirtyCount < 64) {
                dirtyCountField.set(playerChunk, 64);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static IWorldAccess getIWorldAccess(World world) {
        final PlayerChunkMap map = ((CraftWorld)world).getHandle().getPlayerChunkMap();
        return new IWorldAccess(){

            public void a(net.minecraft.server.v1_12_R1.World world, BlockPosition blockPosition, IBlockData iBlockData, IBlockData iBlockData1, int i) {
            }

            public void a(BlockPosition position) {
                map.flagDirty(position);
            }

            public void b(int arg0, BlockPosition arg1, int arg2) {
            }

            public void a(EntityHuman arg0, int arg1, BlockPosition arg2, int arg3) {
            }

            public void a(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            }

            public void a(EntityHuman entityHuman, SoundEffect soundEffect, SoundCategory soundCategory, double v, double v1, double v2, float v3, float v4) {
            }

            public void a(SoundEffect soundEffect, BlockPosition blockPosition) {
            }

            public void a(int arg0, BlockPosition arg1, int arg2) {
            }

            public void a(int arg0, boolean arg1, double arg2, double arg3, double arg4, double arg5, double arg6, double arg7, int ... arg8) {
            }

            public void a(int i, boolean b, boolean b1, double v, double v1, double v2, double v3, double v4, double v5, int ... ints) {
            }

            public void a(Entity arg0) {
            }

            public void b(Entity arg0) {
            }
        };
    }

    static {
        worlds = new HashSet<UUID>();
        Method pcm = null;
        Field dcf = null;
        try {
            pcm = PlayerChunkMap.class.getDeclaredMethod("c", Integer.TYPE, Integer.TYPE);
            pcm.setAccessible(true);
            dcf = pcm.getReturnType().getDeclaredField("dirtyCount");
            dcf.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        playerChunkMethod = pcm;
        dirtyCountField = dcf;
        bukkitTask = new BukkitRunnable(){

            public void run() {
                for (Map.Entry entry : lightsByChunk.entrySet()) {
                    List blockLights;
                    Chunk chunk = (Chunk)entry.getKey();
                    if (!chunk.isLoaded() || (blockLights = (List)entry.getValue()).isEmpty()) continue;
                    PlayerChunkMap playerChunkMap = ((BlockLight_v1_12_R1)blockLights.get(0)).worldServer.getPlayerChunkMap();
                    for (BlockLight light : blockLights) {
                        light.reset(false);
                    }
                    BlockLight_v1_12_R1.updateChunk(chunk, playerChunkMap);
                    for (BlockLight light : blockLights) {
                        light.update(light.cachedLight, false);
                    }
                    BlockLight_v1_12_R1.updateChunk(chunk, playerChunkMap);
                }
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 5L, 5L);
    }
}

