/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptContainer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;

public class ItemScript
implements Property {
    public static final String[] handledTags = new String[]{"has_script", "scriptname", "script"};
    public static final String[] handledMechs = new String[]{"script"};
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem;
    }

    public static ItemScript getFrom(dObject _item) {
        if (!ItemScript.describes(_item)) {
            return null;
        }
        return new ItemScript((dItem)_item);
    }

    private ItemScript(dItem _item) {
        this.item = _item;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("has_script")) {
            return new Element(this.item.isItemscript()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("scriptname") && this.item.isItemscript()) {
            return new Element(this.item.getScriptName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("script") && this.item.isItemscript()) {
            return new dScript(this.item.getScriptName()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        if (this.item.isItemscript()) {
            return this.item.getScriptName();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "script";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("script") && mechanism.requireObject(dScript.class)) {
            dScript script = mechanism.getValue().asType(dScript.class);
            if (script.getContainer() instanceof ItemScriptContainer) {
                this.item.setItemScript((ItemScriptContainer)script.getContainer());
            } else {
                dB.echoError("Script '" + script.getName() + "' is not an item script (but was specified as one).");
            }
        }
    }
}

