/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class BlockDestroyedByExplosionEvent
extends BukkitScriptEvent
implements Listener {
    public static BlockDestroyedByExplosionEvent instance;
    public BlockExplodeEvent blockEvent;
    public EntityExplodeEvent entityEvent;
    public Block block;
    public List<Block> rawList;

    public BlockDestroyedByExplosionEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgsLowEqualStartingAt(1, "destroyed", "by", "explosion", new String[0])) {
            return false;
        }
        return this.couldMatchBlock(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!BlockDestroyedByExplosionEvent.tryMaterial(this.block.getType(), path.eventArgLowerAt(0))) {
            return false;
        }
        if (!this.runInCheck(path, this.block.getLocation())) {
            return false;
        }
        if (path.switches.containsKey("source_entity") && (this.entityEvent == null || !BlockDestroyedByExplosionEvent.tryEntity(new EntityTag(this.entityEvent.getEntity()), path.switches.get("source_entity")))) {
            return false;
        }
        if (path.switches.containsKey("source_block") && (this.blockEvent == null || !BlockDestroyedByExplosionEvent.tryMaterial(this.blockEvent.getBlock().getType(), path.switches.get("source_block")))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "BlockDestroyedByExplosion";
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "block": {
                return new LocationTag(this.block.getLocation());
            }
            case "source_location": {
                return new LocationTag(this.blockEvent != null ? this.blockEvent.getBlock().getLocation() : this.entityEvent.getLocation());
            }
            case "source_entity": {
                return this.entityEvent == null ? null : new EntityTag(this.entityEvent.getEntity());
            }
            case "strength": {
                return new ElementTag(this.blockEvent != null ? this.blockEvent.getYield() : this.entityEvent.getYield());
            }
        }
        return super.getContext(name);
    }

    @Override
    public void cancellationChanged() {
        if (this.cancelled) {
            this.rawList.remove(this.block);
        }
    }

    @EventHandler
    public void onBlockExplodes(BlockExplodeEvent event) {
        this.blockEvent = event;
        this.entityEvent = null;
        this.rawList = event.blockList();
        Iterator<Block> iterator = new ArrayList<Block>(this.rawList).iterator();
        while (iterator.hasNext()) {
            Block block;
            this.block = block = iterator.next();
            this.fire((Event)event);
        }
    }

    @EventHandler
    public void onEntityExplodes(EntityExplodeEvent event) {
        this.entityEvent = event;
        this.blockEvent = null;
        this.rawList = event.blockList();
        Iterator<Block> iterator = new ArrayList<Block>(this.rawList).iterator();
        while (iterator.hasNext()) {
            Block block;
            this.block = block = iterator.next();
            this.fire((Event)event);
        }
    }
}

