/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFadeEvent;

public class BlockFadesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BlockFadesScriptEvent instance;
    public LocationTag location;
    public MaterialTag material;
    public BlockFadeEvent event;

    public BlockFadesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("fades")) {
            return false;
        }
        return this.couldMatchBlock(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!BlockFadesScriptEvent.tryMaterial(this.material, path.eventArgLowerAt(0))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "BlockFades";
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "material": {
                return this.material;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockFades(BlockFadeEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.material = new MaterialTag(event.getBlock());
        this.event = event;
        this.fire((Event)event);
    }
}

