/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Arrays;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;

public class PlayerChangesSignScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerChangesSignScriptEvent instance;
    public LocationTag location;
    public MaterialTag material;
    public SignChangeEvent event;

    public PlayerChangesSignScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("player changes")) {
            return false;
        }
        String sign = path.eventArgAt(2);
        return sign.equals("sign") || this.couldMatchBlock(sign, m -> CoreUtilities.toLowerCase(m.name()).endsWith("sign"));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String mat = path.eventArgLowerAt(2);
        if (!mat.equals("sign") && !PlayerChangesSignScriptEvent.tryMaterial(this.material, mat)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerChangesSign";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (determination.length() > 0) {
            ListTag new_text = ListTag.valueOf(determination, this.getTagContext(path));
            for (int i = 0; i < 4 && i < new_text.size(); ++i) {
                this.event.setLine(i, new_text.get(i));
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "material": {
                return this.material;
            }
            case "new": {
                return new ListTag(Arrays.asList(this.event.getLines()), true);
            }
            case "old": {
                if (this.event.getBlock().getState() instanceof Sign) {
                    return new ListTag(Arrays.asList(((Sign)this.event.getBlock().getState()).getLines()), true);
                }
                return null;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerChangesSign(SignChangeEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        BlockState state = event.getBlock().getState();
        if (!(state instanceof Sign)) {
            return;
        }
        this.material = new MaterialTag(event.getBlock());
        this.location = new LocationTag(event.getBlock().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

