/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_15;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.abstracts.BlockLight;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.abstracts.Sidebar;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_15.helpers.AdvancementHelperImpl;
import com.denizenscript.denizen.nms.v1_15.helpers.AnimationHelperImpl;
import com.denizenscript.denizen.nms.v1_15.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_15.helpers.ChunkHelperImpl;
import com.denizenscript.denizen.nms.v1_15.helpers.CustomEntityHelperImpl;
import com.denizenscript.denizen.nms.v1_15.helpers.EntityHelperImpl;
import com.denizenscript.denizen.nms.v1_15.helpers.FishingHelperImpl;
import com.denizenscript.denizen.nms.v1_15.helpers.ItemHelperImpl;
import com.denizenscript.denizen.nms.v1_15.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_15.helpers.ParticleHelperImpl;
import com.denizenscript.denizen.nms.v1_15.helpers.PlayerHelperImpl;
import com.denizenscript.denizen.nms.v1_15.helpers.SoundHelperImpl;
import com.denizenscript.denizen.nms.v1_15.helpers.WorldHelperImpl;
import com.denizenscript.denizen.nms.v1_15.impl.BiomeNMSImpl;
import com.denizenscript.denizen.nms.v1_15.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_15.impl.SidebarImpl;
import com.denizenscript.denizen.nms.v1_15.impl.blocks.BlockLightImpl;
import com.denizenscript.denizen.nms.v1_15.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.minecraft.server.v1_15_R1.DedicatedServer;
import net.minecraft.server.v1_15_R1.Entity;
import net.minecraft.server.v1_15_R1.IChatBaseComponent;
import net.minecraft.server.v1_15_R1.IInventory;
import net.minecraft.server.v1_15_R1.INamableTileEntity;
import net.minecraft.server.v1_15_R1.NBTBase;
import net.minecraft.server.v1_15_R1.NBTTagByteArray;
import net.minecraft.server.v1_15_R1.NBTTagString;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.v1_15_R1.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.persistence.PersistentDataContainer;
import org.spigotmc.AsyncCatcher;

public class Handler
extends NMSHandler {
    private final ProfileEditor profileEditor = new ProfileEditorImpl();
    private boolean wasAsyncCatcherEnabled;
    public static final Class MINECRAFT_INVENTORY;
    public static final Field INVENTORY_TITLE;
    public static final Field ENTITY_BUKKITYENTITY;

    public Handler() {
        advancementHelper = new AdvancementHelperImpl();
        animationHelper = new AnimationHelperImpl();
        blockHelper = new BlockHelperImpl();
        chunkHelper = new ChunkHelperImpl();
        customEntityHelper = new CustomEntityHelperImpl();
        entityHelper = new EntityHelperImpl();
        fishingHelper = new FishingHelperImpl();
        itemHelper = new ItemHelperImpl();
        soundHelper = new SoundHelperImpl();
        packetHelper = new PacketHelperImpl();
        particleHelper = new ParticleHelperImpl();
        playerHelper = new PlayerHelperImpl();
        worldHelper = new WorldHelperImpl();
    }

    public void disableAsyncCatcher() {
        this.wasAsyncCatcherEnabled = AsyncCatcher.enabled;
        AsyncCatcher.enabled = false;
    }

    public void undisableAsyncCatcher() {
        AsyncCatcher.enabled = this.wasAsyncCatcherEnabled;
    }

    public boolean isCorrectMappingsCode() {
        return ((CraftMagicNumbers)CraftMagicNumbers.INSTANCE).getMappingsVersion().equals("5684afcc1835d966e1b6eb0ed3f72edb");
    }

    public double[] getRecentTps() {
        return ((CraftServer)Bukkit.getServer()).getServer().recentTps;
    }

    public CompoundTag createCompoundTag(Map<String, Tag> value) {
        return new CompoundTagImpl(value);
    }

    public Sidebar createSidebar(Player player) {
        return new SidebarImpl(player);
    }

    public BlockLight createBlockLight(Location location, int lightLevel, long ticks) {
        return BlockLightImpl.createLight(location, lightLevel, ticks);
    }

    public PlayerProfile fillPlayerProfile(PlayerProfile playerProfile) {
        block12: {
            try {
                if (playerProfile != null) {
                    GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
                    gameProfile.getProperties().get((Object)"textures").clear();
                    if (playerProfile.getTextureSignature() != null) {
                        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
                    } else {
                        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture()));
                    }
                    DedicatedServer minecraftServer = ((CraftServer)Bukkit.getServer()).getServer();
                    GameProfile gameProfile1 = null;
                    if (gameProfile.getId() != null) {
                        gameProfile1 = minecraftServer.getUserCache().getProfile(gameProfile.getId());
                    }
                    if (gameProfile1 == null && gameProfile.getName() != null) {
                        gameProfile1 = minecraftServer.getUserCache().getProfile(gameProfile.getName());
                    }
                    if (gameProfile1 == null) {
                        gameProfile1 = gameProfile;
                    }
                    if (playerProfile.hasTexture()) {
                        gameProfile1.getProperties().get((Object)"textures").clear();
                        if (playerProfile.getTextureSignature() != null) {
                            gameProfile1.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
                        } else {
                            gameProfile1.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture()));
                        }
                    }
                    if (Iterables.getFirst((Iterable)gameProfile1.getProperties().get((Object)"textures"), null) == null) {
                        gameProfile1 = minecraftServer.getMinecraftSessionService().fillProfileProperties(gameProfile1, true);
                    }
                    Property property = (Property)Iterables.getFirst((Iterable)gameProfile1.getProperties().get((Object)"textures"), null);
                    return new PlayerProfile(gameProfile1.getName(), gameProfile1.getId(), property != null ? property.getValue() : null, property != null ? property.getSignature() : null);
                }
            }
            catch (Exception e) {
                if (!Debug.verbose) break block12;
                Debug.echoError((Throwable)e);
            }
        }
        return null;
    }

    public int getPort() {
        return ((CraftServer)Bukkit.getServer()).getServer().getPort();
    }

    public String getTitle(Inventory inventory) {
        IInventory nms = ((CraftInventory)inventory).getInventory();
        if (nms instanceof INamableTileEntity) {
            return CraftChatMessage.fromComponent((IChatBaseComponent)((INamableTileEntity)nms).getDisplayName());
        }
        if (MINECRAFT_INVENTORY.isInstance(nms)) {
            try {
                return (String)INVENTORY_TITLE.get(nms);
            }
            catch (IllegalAccessException e) {
                Debug.echoError((Throwable)e);
            }
        }
        return "Chest";
    }

    public PlayerProfile getPlayerProfile(Player player) {
        GameProfile gameProfile = ((CraftPlayer)player).getProfile();
        Property property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(gameProfile.getName(), gameProfile.getId(), property != null ? property.getValue() : null, property != null ? property.getSignature() : null);
    }

    public ProfileEditor getProfileEditor() {
        return this.profileEditor;
    }

    public BiomeNMS getBiomeNMS(World world, String name) {
        for (Biome biome : Biome.values()) {
            if (!biome.name().equalsIgnoreCase(name)) continue;
            return new BiomeNMSImpl(world, biome);
        }
        return null;
    }

    public String stringForHover(HoverEvent hover) {
        return FormattedTextHelper.stringify((BaseComponent[])hover.getValue(), (ChatColor)ChatColor.WHITE);
    }

    public ArrayList<String> containerListFlags(PersistentDataContainer container, String prefix) {
        prefix = "denizen:" + prefix;
        ArrayList<String> output = new ArrayList<String>();
        for (String key : ((CraftPersistentDataContainer)container).getRaw().keySet()) {
            if (!key.startsWith(prefix)) continue;
            output.add(key.substring(prefix.length()));
        }
        return output;
    }

    public boolean containerHas(PersistentDataContainer container, String key) {
        return ((CraftPersistentDataContainer)container).getRaw().containsKey(key);
    }

    public String containerGetString(PersistentDataContainer container, String key) {
        NBTBase base = (NBTBase)((CraftPersistentDataContainer)container).getRaw().get(key);
        if (base instanceof NBTTagString) {
            return base.asString();
        }
        if (base instanceof NBTTagByteArray) {
            return new String(((NBTTagByteArray)base).getBytes(), StandardCharsets.UTF_8);
        }
        return null;
    }

    static {
        ENTITY_BUKKITYENTITY = ReflectionHelper.getFields(Entity.class).get((Object)"bukkitEntity");
        Class<?> minecraftInv = null;
        Field title = null;
        try {
            for (Class<?> clzz : CraftInventoryCustom.class.getDeclaredClasses()) {
                if (!CoreUtilities.toLowerCase((String)clzz.getName()).contains("minecraftinventory")) continue;
                minecraftInv = clzz;
                title = clzz.getDeclaredField("title");
                title.setAccessible(true);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MINECRAFT_INVENTORY = minecraftInv;
        INVENTORY_TITLE = title;
    }
}

