/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.entity.ColorHelper1_17;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Arrays;
import org.bukkit.DyeColor;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Cat;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;

public class EntityColor
implements Property {
    public static final String[] handledTags = new String[]{"color", "allowed_colors"};
    public static final String[] handledMechs = new String[]{"color"};
    EntityTag colored;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        EntityType type = ((EntityTag)entity).getBukkitEntityType();
        return type == EntityType.SHEEP || type == EntityType.HORSE || type == EntityType.WOLF || type == EntityType.OCELOT || type == EntityType.RABBIT || type == EntityType.LLAMA || type == EntityType.PARROT || type == EntityType.SHULKER || type == EntityType.MUSHROOM_COW || type == EntityType.CAT || type == EntityType.FOX || type == EntityType.PANDA || type == EntityType.ARROW || type == EntityType.VILLAGER || type == EntityType.TRADER_LLAMA || type == EntityType.TROPICAL_FISH || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && ColorHelper1_17.colorIsApplicable(type);
    }

    public static EntityColor getFrom(ObjectTag entity) {
        if (!EntityColor.describes(entity)) {
            return null;
        }
        return new EntityColor((EntityTag)entity);
    }

    private EntityColor(EntityTag entity) {
        this.colored = entity;
    }

    public String getColor(boolean includeDeprecated) {
        EntityType type = this.colored.getBukkitEntityType();
        if (type == EntityType.HORSE) {
            Horse horse = (Horse)this.colored.getBukkitEntity();
            return horse.getColor().name() + "|" + horse.getStyle().name();
        }
        if (type == EntityType.SHEEP) {
            return ((Sheep)this.colored.getBukkitEntity()).getColor().name();
        }
        if (type == EntityType.WOLF) {
            return ((Wolf)this.colored.getBukkitEntity()).getCollarColor().name();
        }
        if (type == EntityType.OCELOT && includeDeprecated) {
            return ((Ocelot)this.colored.getBukkitEntity()).getCatType().name();
        }
        if (type == EntityType.RABBIT) {
            return ((Rabbit)this.colored.getBukkitEntity()).getRabbitType().name();
        }
        if (type == EntityType.LLAMA || type == EntityType.TRADER_LLAMA) {
            return ((Llama)this.colored.getBukkitEntity()).getColor().name();
        }
        if (type == EntityType.PARROT) {
            return ((Parrot)this.colored.getBukkitEntity()).getVariant().name();
        }
        if (type == EntityType.SHULKER) {
            DyeColor color = ((Shulker)this.colored.getBukkitEntity()).getColor();
            return color == null ? null : color.name();
        }
        if (type == EntityType.MUSHROOM_COW) {
            return ((MushroomCow)this.colored.getBukkitEntity()).getVariant().name();
        }
        if (type == EntityType.TROPICAL_FISH) {
            TropicalFish fish = (TropicalFish)this.colored.getBukkitEntity();
            return new ListTag(Arrays.asList(fish.getPattern().name(), fish.getBodyColor().name(), fish.getPatternColor().name())).identify();
        }
        if (type == EntityType.FOX) {
            return ((Fox)this.colored.getBukkitEntity()).getFoxType().name();
        }
        if (type == EntityType.CAT) {
            Cat cat = (Cat)this.colored.getBukkitEntity();
            return cat.getCatType().name() + "|" + cat.getCollarColor().name();
        }
        if (type == EntityType.PANDA) {
            Panda panda = (Panda)this.colored.getBukkitEntity();
            return panda.getMainGene().name() + "|" + panda.getHiddenGene().name();
        }
        if (type == EntityType.VILLAGER) {
            return ((Villager)this.colored.getBukkitEntity()).getVillagerType().name();
        }
        if (type == EntityType.ARROW) {
            try {
                return new ColorTag(((Arrow)this.colored.getBukkitEntity()).getColor()).identify();
            }
            catch (Exception e) {
                return null;
            }
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && ColorHelper1_17.colorIsApplicable(type)) {
            return ColorHelper1_17.getColor(this.colored.getBukkitEntity());
        }
        return null;
    }

    public static ListTag listForEnum(Enum<?>[] values) {
        ListTag list = new ListTag(values.length);
        for (Enum<?> obj : values) {
            list.addObject(new ElementTag(obj.name()));
        }
        return list;
    }

    public ListTag getAllowedColors() {
        EntityType type = this.colored.getBukkitEntityType();
        if (type == EntityType.HORSE) {
            ListTag toRet = EntityColor.listForEnum(Horse.Color.values());
            toRet.addAll(EntityColor.listForEnum(Horse.Style.values()));
            return toRet;
        }
        if (type == EntityType.SHEEP) {
            return EntityColor.listForEnum(DyeColor.values());
        }
        if (type == EntityType.WOLF) {
            return EntityColor.listForEnum(DyeColor.values());
        }
        if (type == EntityType.RABBIT) {
            return EntityColor.listForEnum(Rabbit.Type.values());
        }
        if (type == EntityType.LLAMA || type == EntityType.TRADER_LLAMA) {
            return EntityColor.listForEnum(Llama.Color.values());
        }
        if (type == EntityType.PARROT) {
            return EntityColor.listForEnum(Parrot.Variant.values());
        }
        if (type == EntityType.SHULKER) {
            return EntityColor.listForEnum(DyeColor.values());
        }
        if (type == EntityType.MUSHROOM_COW) {
            return EntityColor.listForEnum(MushroomCow.Variant.values());
        }
        if (type == EntityType.TROPICAL_FISH) {
            ListTag toRet = EntityColor.listForEnum(TropicalFish.Pattern.values());
            toRet.addAll(EntityColor.listForEnum(DyeColor.values()));
            return toRet;
        }
        if (type == EntityType.FOX) {
            return EntityColor.listForEnum(Fox.Type.values());
        }
        if (type == EntityType.CAT) {
            return EntityColor.listForEnum(Cat.Type.values());
        }
        if (type == EntityType.PANDA) {
            return EntityColor.listForEnum(Panda.Gene.values());
        }
        if (type == EntityType.VILLAGER) {
            return EntityColor.listForEnum(Villager.Type.values());
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && ColorHelper1_17.colorIsApplicable(type)) {
            return ColorHelper1_17.getAllowedColors(type);
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        String color = this.getColor(false);
        return color == null ? null : CoreUtilities.toLowerCase(color);
    }

    @Override
    public String getPropertyId() {
        return "color";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("allowed_colors")) {
            ListTag colors = this.getAllowedColors();
            if (colors == null) {
                return null;
            }
            return colors.getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("color")) {
            String color = CoreUtilities.toLowerCase(this.getColor(true));
            if (color == null) {
                return null;
            }
            return new ElementTag(color).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("color")) {
            EntityType type = this.colored.getBukkitEntityType();
            if (type == EntityType.HORSE) {
                ListTag horse_info = mechanism.valueAsType(ListTag.class);
                if (horse_info.size() > 0 && new ElementTag(horse_info.get(0)).matchesEnum((Enum[])Horse.Color.values())) {
                    ((Horse)this.colored.getBukkitEntity()).setColor(Horse.Color.valueOf((String)horse_info.get(0).toUpperCase()));
                }
                if (horse_info.size() > 1 && new ElementTag(horse_info.get(1)).matchesEnum((Enum[])Horse.Style.values())) {
                    ((Horse)this.colored.getBukkitEntity()).setStyle(Horse.Style.valueOf((String)horse_info.get(1).toUpperCase()));
                }
            } else if (type == EntityType.SHEEP && mechanism.getValue().matchesEnum((Enum[])DyeColor.values())) {
                ((Sheep)this.colored.getBukkitEntity()).setColor(DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.WOLF && mechanism.getValue().matchesEnum((Enum[])DyeColor.values())) {
                ((Wolf)this.colored.getBukkitEntity()).setCollarColor(DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.OCELOT && mechanism.getValue().matchesEnum((Enum[])Ocelot.Type.values())) {
                ((Ocelot)this.colored.getBukkitEntity()).setCatType(Ocelot.Type.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.RABBIT && mechanism.getValue().matchesEnum((Enum[])Rabbit.Type.values())) {
                ((Rabbit)this.colored.getBukkitEntity()).setRabbitType(Rabbit.Type.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if ((type == EntityType.LLAMA || type == EntityType.TRADER_LLAMA) && mechanism.getValue().matchesEnum((Enum[])Llama.Color.values())) {
                ((Llama)this.colored.getBukkitEntity()).setColor(Llama.Color.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.PARROT && mechanism.getValue().matchesEnum((Enum[])Parrot.Variant.values())) {
                ((Parrot)this.colored.getBukkitEntity()).setVariant(Parrot.Variant.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.SHULKER && mechanism.getValue().matchesEnum((Enum[])DyeColor.values())) {
                ((Shulker)this.colored.getBukkitEntity()).setColor(DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.MUSHROOM_COW) {
                ((MushroomCow)this.colored.getBukkitEntity()).setVariant(MushroomCow.Variant.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.TROPICAL_FISH) {
                ListTag list = ListTag.valueOf(mechanism.getValue().asString(), CoreUtilities.basicContext);
                TropicalFish fish = (TropicalFish)this.colored.getBukkitEntity();
                fish.setPattern(TropicalFish.Pattern.valueOf((String)list.get(0).toUpperCase()));
                if (list.size() > 1) {
                    fish.setBodyColor(DyeColor.valueOf((String)list.get(1).toUpperCase()));
                }
                if (list.size() > 2) {
                    fish.setPatternColor(DyeColor.valueOf((String)list.get(2).toUpperCase()));
                }
            } else if (type == EntityType.FOX) {
                ((Fox)this.colored.getBukkitEntity()).setFoxType(Fox.Type.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.CAT) {
                Cat cat = (Cat)this.colored.getBukkitEntity();
                ListTag list = ListTag.valueOf(mechanism.getValue().asString(), CoreUtilities.basicContext);
                cat.setCatType(Cat.Type.valueOf((String)list.get(0).toUpperCase()));
                if (list.size() > 1) {
                    cat.setCollarColor(DyeColor.valueOf((String)list.get(1).toUpperCase()));
                }
            } else if (type == EntityType.PANDA) {
                Panda panda = (Panda)this.colored.getBukkitEntity();
                ListTag list = ListTag.valueOf(mechanism.getValue().asString(), CoreUtilities.basicContext);
                panda.setMainGene(Panda.Gene.valueOf((String)list.get(0).toUpperCase()));
                panda.setHiddenGene(Panda.Gene.valueOf((String)list.get(1).toUpperCase()));
            } else if (type == EntityType.VILLAGER) {
                ((Villager)this.colored.getBukkitEntity()).setVillagerType(Villager.Type.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.ARROW) {
                ((Arrow)this.colored.getBukkitEntity()).setColor(mechanism.valueAsType(ColorTag.class).getColor());
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && ColorHelper1_17.colorIsApplicable(type)) {
                ColorHelper1_17.setColor(this.colored.getBukkitEntity(), mechanism);
            } else {
                mechanism.echoError("Could not apply color '" + mechanism.getValue().toString() + "' to entity of type " + type.name() + ".");
            }
        }
    }
}

