/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.command.scripted;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.CommandScriptContainer;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.tags.TagManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.CommandMinecart;

public class DenizenCommand
extends Command {
    private CommandScriptContainer script;

    public DenizenCommand(CommandScriptContainer script) {
        super(script.getCommandName(), script.getDescription(), script.getUsage(), script.getAliases());
        String permission = script.getPermission();
        if (permission != null && !permission.equals("")) {
            this.setPermission(permission);
            String permissionMessage = script.getPermissionMessage();
            if (permissionMessage != null && !permissionMessage.equals("")) {
                this.setPermissionMessage(permissionMessage);
            }
        }
        this.script = script;
    }

    public boolean canSeeHelp(CommandSender commandSender) {
        if (!this.script.hasAllowedHelpProcedure()) {
            return true;
        }
        if (!this.testPermissionSilent(commandSender)) {
            return false;
        }
        HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
        PlayerTag player = null;
        NPCTag npc = null;
        if (commandSender instanceof Player) {
            Player pl = (Player)commandSender;
            if (!EntityTag.isNPC((Entity)pl)) {
                player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)pl);
            }
            context.put("server", new ElementTag(false));
        } else {
            context.put("server", new ElementTag(true));
        }
        return this.script.runAllowedHelpProcedure(player, npc, context);
    }

    public boolean testPermission(CommandSender target) {
        if (this.testPermissionSilent(target)) {
            return true;
        }
        String permissionMessage = this.getPermissionMessage();
        if (permissionMessage == null) {
            target.sendMessage(ChatColor.RED + "I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.");
        } else if (permissionMessage.length() != 0) {
            NPC citizen;
            PlayerTag player = null;
            NPCTag npc = null;
            if (target instanceof Player) {
                Player pl = (Player)target;
                if (EntityTag.isCitizensNPC((Entity)pl)) {
                    npc = NPCTag.fromEntity((Entity)pl);
                } else {
                    player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)pl);
                }
            }
            if (Depends.citizens != null && npc == null && (citizen = CitizensAPI.getDefaultNPCSelector().getSelected(target)) != null) {
                npc = new NPCTag(citizen);
            }
            for (String line : TagManager.tag(permissionMessage.replace("<permission>", this.getPermission()), new BukkitTagContext(player, npc, null, false, new ScriptTag(this.script))).split("\n")) {
                target.sendMessage(line);
            }
        }
        return false;
    }

    public boolean execute(CommandSender commandSender, String commandLabel, String[] arguments) {
        NPC citizen;
        if (!this.testPermission(commandSender)) {
            return true;
        }
        HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
        String raw_args = "";
        if (arguments.length > 0) {
            StringBuilder rawArgsBuilder = new StringBuilder();
            for (String arg : arguments) {
                rawArgsBuilder.append(arg).append(' ');
            }
            raw_args = rawArgsBuilder.substring(0, rawArgsBuilder.length() - 1);
        }
        List<String> args = Arrays.asList(ArgumentHelper.buildArgs(raw_args));
        context.put("args", new ListTag(args, true));
        context.put("raw_args", new ElementTag(raw_args, true));
        context.put("alias", new ElementTag(commandLabel, true));
        PlayerTag player = null;
        NPCTag npc = null;
        if (commandSender instanceof Player) {
            Player pl = (Player)commandSender;
            if (EntityTag.isCitizensNPC((Entity)pl)) {
                npc = NPCTag.fromEntity((Entity)pl);
            } else {
                player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)pl);
            }
            context.put("server", new ElementTag(false));
            context.put("source_type", new ElementTag("player"));
        } else if (commandSender instanceof BlockCommandSender) {
            context.put("command_block_location", new LocationTag(((BlockCommandSender)commandSender).getBlock().getLocation()));
            context.put("server", new ElementTag(false));
            context.put("source_type", new ElementTag("command_block"));
        } else if (commandSender instanceof CommandMinecart) {
            context.put("command_minecart", new EntityTag((Entity)((CommandMinecart)commandSender)));
            context.put("server", new ElementTag(false));
            context.put("source_type", new ElementTag("command_minecart"));
        } else {
            context.put("server", new ElementTag(true));
            context.put("source_type", new ElementTag("server"));
        }
        if (Depends.citizens != null && npc == null && (citizen = CitizensAPI.getDefaultNPCSelector().getSelected(commandSender)) != null) {
            npc = new NPCTag(citizen);
        }
        this.script.runCommandScript(player, npc, context);
        return true;
    }

    public boolean isRegistered() {
        return true;
    }

    public List<String> tabComplete(CommandSender commandSender, String alias, String[] arguments) {
        NPC citizen;
        if (!this.script.hasTabCompleteProcedure()) {
            return super.tabComplete(commandSender, alias, arguments);
        }
        HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
        String raw_args = "";
        if (arguments.length > 0) {
            StringBuilder rawArgsBuilder = new StringBuilder();
            for (String arg : arguments) {
                rawArgsBuilder.append(arg).append(' ');
            }
            raw_args = rawArgsBuilder.substring(0, rawArgsBuilder.length() - 1);
        }
        List<String> args = Arrays.asList(ArgumentHelper.buildArgs(raw_args));
        context.put("args", new ListTag(args, true));
        context.put("raw_args", new ElementTag(raw_args, true));
        context.put("alias", new ElementTag(alias, true));
        PlayerTag player = null;
        NPCTag npc = null;
        if (commandSender instanceof Player) {
            Player pl = (Player)commandSender;
            if (EntityTag.isCitizensNPC((Entity)pl)) {
                npc = NPCTag.fromEntity((Entity)pl);
            } else {
                player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)pl);
            }
            context.put("server", new ElementTag(false));
        } else {
            context.put("server", new ElementTag(true));
        }
        if (Depends.citizens != null && npc == null && (citizen = CitizensAPI.getDefaultNPCSelector().getSelected(commandSender)) != null) {
            npc = new NPCTag(citizen);
        }
        return this.script.runTabCompleteProcedure(player, npc, context, arguments);
    }
}

