/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.BoundingBox;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.v1_17.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_17.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_17.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.BlockFace;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_17_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftFirework;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftGhast;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftItem;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftShulker;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftTrident;
import org.bukkit.craftbukkit.v1_17_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class EntityHelperImpl
extends EntityHelper {
    public static final Field RECIPE_BOOK_DISCOVERED_SET = ReflectionHelper.getFields(RecipeBook.class).get((Object)ReflectionMappingsInfo.RecipeBook_known);
    public static final MethodHandle ENTITY_ONGROUND_SETTER = ReflectionHelper.getFinalSetter(net.minecraft.world.entity.Entity.class, (String)ReflectionMappingsInfo.Entity_onGround);
    public static final DataWatcherObject<Boolean> ENTITY_ENDERMAN_DATAWATCHER_SCREAMING = (DataWatcherObject)ReflectionHelper.getFieldValue(EntityEnderman.class, (String)ReflectionMappingsInfo.EnderMan_DATA_CREEPY, null);
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();
    public static final MethodHandle FALLINGBLOCK_TYPE_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(EntityFallingBlock.class, IBlockData.class);

    public void setInvisible(Entity entity, boolean invisible) {
        ((CraftEntity)entity).getHandle().setInvisible(invisible);
    }

    public double getAbsorption(LivingEntity entity) {
        return entity.getAbsorptionAmount();
    }

    public void setAbsorption(LivingEntity entity, double value) {
        entity.setAbsorptionAmount(value);
    }

    public void setSneaking(Entity player, boolean sneak) {
        if (player instanceof Player) {
            ((Player)player).setSneaking(sneak);
        }
        EntityPose pose = sneak ? EntityPose.f : EntityPose.a;
        ((CraftEntity)player).getHandle().setPose(pose);
    }

    public double getDamageTo(LivingEntity attacker, Entity target) {
        EnumMonsterType monsterType = target instanceof LivingEntity ? ((CraftLivingEntity)target).getHandle().getMonsterType() : EnumMonsterType.a;
        double damage = 0.0;
        AttributeInstance attrib = attacker.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
        if (attrib != null) {
            damage = attrib.getValue();
        }
        if (attacker.getEquipment() != null && attacker.getEquipment().getItemInMainHand() != null) {
            damage += (double)EnchantmentManager.a((net.minecraft.world.item.ItemStack)CraftItemStack.asNMSCopy((ItemStack)attacker.getEquipment().getItemInMainHand()), (EnumMonsterType)monsterType);
        }
        if (damage <= 0.0) {
            return 0.0;
        }
        if (target != null) {
            DamageSource source = attacker instanceof Player ? DamageSource.playerAttack((EntityHuman)((CraftPlayer)attacker).getHandle()) : DamageSource.mobAttack((EntityLiving)((CraftLivingEntity)attacker).getHandle());
            net.minecraft.world.entity.Entity nmsTarget = ((CraftEntity)target).getHandle();
            if (nmsTarget.isInvulnerable(source)) {
                return 0.0;
            }
            if (!(nmsTarget instanceof EntityLiving)) {
                return damage;
            }
            EntityLiving livingTarget = (EntityLiving)nmsTarget;
            damage = CombatMath.a((float)((float)damage), (float)livingTarget.getArmorStrength(), (float)((float)livingTarget.b(GenericAttributes.j)));
            int enchantDamageModifier = EnchantmentManager.a((Iterable)livingTarget.getArmorItems(), (DamageSource)source);
            if (enchantDamageModifier > 0) {
                damage = CombatMath.a((float)((float)damage), (float)enchantDamageModifier);
            }
        }
        return damage;
    }

    public String getRawHoverText(Entity entity) {
        throw new UnsupportedOperationException();
    }

    public List<String> getDiscoveredRecipes(Player player) {
        try {
            RecipeBookServer book = ((CraftPlayer)player).getHandle().getRecipeBook();
            Set set = (Set)RECIPE_BOOK_DISCOVERED_SET.get(book);
            ArrayList<String> output = new ArrayList<String>();
            for (MinecraftKey key : set) {
                output.add(key.toString());
            }
            return output;
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public String getArrowPickupStatus(Entity entity) {
        return ((Arrow)entity).getPickupStatus().name();
    }

    public void setArrowPickupStatus(Entity entity, String status) {
        ((Arrow)entity).setPickupStatus(AbstractArrow.PickupStatus.valueOf((String)status));
    }

    public double getArrowDamage(Entity arrow) {
        return ((Arrow)arrow).getDamage();
    }

    public void setArrowDamage(Entity arrow, double damage) {
        ((Arrow)arrow).setDamage(damage);
    }

    public void setCarriedItem(Enderman entity, ItemStack item) {
        entity.setCarriedBlock(Bukkit.createBlockData((Material)item.getType()));
    }

    public void setRiptide(Entity entity, boolean state) {
        ((CraftLivingEntity)entity).getHandle().s(state ? 0 : 1);
    }

    public int getBodyArrows(Entity entity) {
        return ((CraftLivingEntity)entity).getHandle().getArrowCount();
    }

    public void setBodyArrows(Entity entity, int numArrows) {
        ((CraftLivingEntity)entity).getHandle().setArrowCount(numArrows);
    }

    public Entity getFishHook(PlayerFishEvent event) {
        return event.getHook();
    }

    public ItemStack getItemFromTrident(Entity entity) {
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)((CraftTrident)entity).getHandle().aq);
    }

    public void setItemForTrident(Entity entity, ItemStack item) {
        ((CraftTrident)entity).getHandle().aq = CraftItemStack.asNMSCopy((ItemStack)item);
    }

    public void forceInteraction(Player player, Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftBlock)location.getBlock()).getNMS().interact((net.minecraft.world.level.World)((CraftWorld)location.getWorld()).getHandle(), (EntityHuman)(craftPlayer != null ? craftPlayer.getHandle() : null), EnumHand.a, new MovingObjectPositionBlock(new Vec3D(0.0, 0.0, 0.0), null, pos, false));
    }

    public Entity getEntity(World world, UUID uuid) {
        net.minecraft.world.entity.Entity entity = ((CraftWorld)world).getHandle().getEntity(uuid);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public void setTarget(Creature entity, LivingEntity target) {
        EntityLiving nmsTarget = target != null ? ((CraftLivingEntity)target).getHandle() : null;
        ((CraftCreature)entity).getHandle().setGoalTarget(nmsTarget, EntityTargetEvent.TargetReason.CUSTOM, true);
        entity.setTarget(target);
    }

    public CompoundTag getNbtData(Entity entity) {
        NBTTagCompound compound = new NBTTagCompound();
        ((CraftEntity)entity).getHandle().d(compound);
        return CompoundTagImpl.fromNMSTag(compound);
    }

    public void setNbtData(Entity entity, CompoundTag compoundTag) {
        ((CraftEntity)entity).getHandle().load(((CompoundTagImpl)compoundTag).toNMSTag());
    }

    public void stopFollowing(Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    public void stopWalking(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        ((EntityInsentient)nmsEntity).getNavigation().o();
    }

    public double getSpeed(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return 0.0;
        }
        EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        return nmsEntity.getAttributeInstance(GenericAttributes.d).getBaseValue();
    }

    public void setSpeed(Entity entity, double speed) {
        net.minecraft.world.entity.Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        nmsEntity.getAttributeInstance(GenericAttributes.d).setValue(speed);
    }

    public void follow(final Entity target, final Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander, final boolean teleport) {
        if (target == null || follower == null) {
            return;
        }
        net.minecraft.world.entity.Entity nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsFollower = (EntityInsentient)nmsEntityFollower;
        final NavigationAbstract followerNavigation = nmsFollower.getNavigation();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        if (teleport) {
                            follower.teleport(Utilities.getWalkableLocationNear((Location)targetLocation, (int)locationNearInt));
                        } else {
                            this.cancel();
                        }
                    } else {
                        this.inRadius = false;
                        PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)lead)) {
                    PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.o();
                }
                nmsFollower.getAttributeInstance(GenericAttributes.d).setValue(speed);
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 0L, 10L));
    }

    public void walkTo(final LivingEntity entity, Location location, final Double speed, final Runnable callback) {
        PathEntity path;
        boolean aiDisabled;
        if (entity == null || location == null) {
            return;
        }
        net.minecraft.world.entity.Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        final NavigationAbstract entityNavigation = nmsEntity.getNavigation();
        boolean bl = aiDisabled = !entity.hasAI();
        if (aiDisabled) {
            entity.setAI(true);
            try {
                ENTITY_ONGROUND_SETTER.invoke(nmsEntity, true);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        if ((path = entityNavigation.a(location.getX(), location.getY(), location.getZ(), 1)) != null) {
            nmsEntity.bP.b(PathfinderGoal.Type.a);
            entityNavigation.a(path, 1.0);
            entityNavigation.a(2.0);
            final double oldSpeed = nmsEntity.getAttributeInstance(GenericAttributes.d).getBaseValue();
            if (speed != null) {
                nmsEntity.getAttributeInstance(GenericAttributes.d).setValue(speed.doubleValue());
            }
            new BukkitRunnable(){

                public void run() {
                    if (!entity.isValid()) {
                        if (callback != null) {
                            callback.run();
                        }
                        this.cancel();
                        return;
                    }
                    if (aiDisabled && entity instanceof Wolf) {
                        ((Wolf)entity).setAngry(false);
                    }
                    if (entityNavigation.m() || path.c()) {
                        if (callback != null) {
                            callback.run();
                        }
                        if (speed != null) {
                            nmsEntity.getAttributeInstance(GenericAttributes.d).setValue(oldSpeed);
                        }
                        if (aiDisabled) {
                            entity.setAI(false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 1L, 1L);
        } else {
            entity.teleport(location);
        }
    }

    public List<Player> getPlayersThatSee(Entity entity) {
        PlayerChunkMap tracker = ((WorldServer)((CraftEntity)entity).getHandle().t).getChunkProvider().a;
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)tracker.G.get(entity.getEntityId());
        ArrayList<Player> output = new ArrayList<Player>();
        if (entityTracker == null) {
            return output;
        }
        for (ServerPlayerConnection player : entityTracker.f) {
            output.add((Player)player.d().getBukkitEntity());
        }
        return output;
    }

    public void sendHidePacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            pl.hidePlayer((Plugin)Denizen.getInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.b != null && !craftPlayer.equals((Object)entity)) {
            PlayerChunkMap tracker = ((WorldServer)craftPlayer.getHandle().t).getChunkProvider().a;
            net.minecraft.world.entity.Entity other = ((CraftEntity)entity).getHandle();
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)tracker.G.get(other.getId());
            if (entry != null) {
                entry.clear(entityPlayer);
            }
            if (Denizen.supportsPaper) {
                entityPlayer.b.sendPacket((Packet)new PacketPlayOutEntityDestroy(new int[]{other.getId()}));
            }
        }
    }

    public void sendShowPacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            pl.showPlayer((Plugin)Denizen.getInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.b != null && !craftPlayer.equals((Object)entity)) {
            PlayerChunkMap tracker = ((WorldServer)craftPlayer.getHandle().t).getChunkProvider().a;
            net.minecraft.world.entity.Entity other = ((CraftEntity)entity).getHandle();
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)tracker.G.get(other.getId());
            if (entry != null) {
                entry.clear(entityPlayer);
                entry.updatePlayer(entityPlayer);
            }
        }
    }

    public void rotate(Entity entity, float yaw, float pitch) {
        if (entity instanceof Player && ((Player)entity).isOnline()) {
            Location location = entity.getLocation();
            location.setYaw(yaw);
            location.setPitch(pitch);
            this.teleport(entity, location);
        } else if (entity instanceof LivingEntity) {
            if (entity instanceof EnderDragon) {
                yaw = EntityHelperImpl.normalizeYaw((float)(yaw - 180.0f));
            }
            this.look(entity, yaw, pitch);
        } else {
            net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
            handle.setYRot(yaw - 360.0f);
            handle.setXRot(pitch);
        }
    }

    public float getBaseYaw(Entity entity) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
        return ((EntityLiving)handle).aX;
    }

    public void look(Entity entity, float yaw, float pitch) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
        if (handle != null) {
            handle.setYRot(yaw);
            if (handle instanceof EntityLiving) {
                EntityLiving livingHandle = (EntityLiving)handle;
                while (yaw < -180.0f) {
                    yaw += 360.0f;
                }
                while (yaw >= 180.0f) {
                    yaw -= 360.0f;
                }
                livingHandle.aY = yaw;
                if (!(handle instanceof EntityHuman)) {
                    livingHandle.m(yaw);
                }
                livingHandle.setHeadRotation(yaw);
            }
            handle.setXRot(pitch);
        } else {
            Debug.echoError((String)("Cannot set look direction for unspawned entity " + entity.getUniqueId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MovingObjectPosition rayTrace(World world, Vector start, Vector end) {
        try {
            NMSHandler.getChunkHelper().changeChunkServerThread(world);
            MovingObjectPositionBlock movingObjectPositionBlock = ((CraftWorld)world).getHandle().rayTrace(new RayTrace(new Vec3D(start.getX(), start.getY(), start.getZ()), new Vec3D(end.getX(), end.getY(), end.getZ()), RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, null));
            return movingObjectPositionBlock;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(world);
        }
    }

    public boolean canTrace(World world, Vector start, Vector end) {
        MovingObjectPosition pos = EntityHelperImpl.rayTrace(world, start, end);
        if (pos == null) {
            return true;
        }
        return pos.getType() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public EntityHelper.MapTraceResult mapTrace(LivingEntity from, double range) {
        Location start = from.getEyeLocation();
        Vector startVec = start.toVector();
        double xzLen = Math.cos((double)(start.getPitch() % 360.0f) * (Math.PI / 180));
        double nx = xzLen * Math.sin((double)(-start.getYaw()) * (Math.PI / 180));
        double ny = Math.sin((double)start.getPitch() * (Math.PI / 180));
        double nz = xzLen * Math.cos((double)start.getYaw() * (Math.PI / 180));
        Vector endVec = startVec.clone().add(new Vector(nx, -ny, nz).multiply(range));
        MovingObjectPosition l = EntityHelperImpl.rayTrace(start.getWorld(), startVec, endVec);
        if (!(l instanceof MovingObjectPositionBlock) || l.getPos() == null) {
            return null;
        }
        Vector finalVec = new Vector(l.getPos().b, l.getPos().c, l.getPos().d);
        EntityHelper.MapTraceResult mtr = new EntityHelper.MapTraceResult();
        switch (((MovingObjectPositionBlock)l).getDirection()) {
            case c: {
                mtr.angle = BlockFace.NORTH;
                break;
            }
            case d: {
                mtr.angle = BlockFace.SOUTH;
                break;
            }
            case f: {
                mtr.angle = BlockFace.EAST;
                break;
            }
            case e: {
                mtr.angle = BlockFace.WEST;
            }
        }
        Vector hit = finalVec.clone().subtract(endVec.clone().subtract(startVec).normalize().multiply(0.072));
        mtr.hitLocation = new Location(start.getWorld(), hit.getX(), hit.getY(), hit.getZ());
        return mtr;
    }

    public void snapPositionTo(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().setPositionRaw(vector.getX(), vector.getY(), vector.getZ());
    }

    public void move(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().move(EnumMoveType.a, new Vec3D(vector.getX(), vector.getY(), vector.getZ()));
    }

    public void teleport(Entity entity, Location loc) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.setYRot(loc.getYaw());
        nmsEntity.setXRot(loc.getPitch());
        if (nmsEntity instanceof EntityPlayer) {
            nmsEntity.enderTeleportTo(loc.getX(), loc.getY(), loc.getZ());
        }
        nmsEntity.setPosition(loc.getX(), loc.getY(), loc.getZ());
    }

    public BoundingBox getBoundingBox(Entity entity) {
        AxisAlignedBB boundingBox = ((CraftEntity)entity).getHandle().getBoundingBox();
        Vector position = new Vector(boundingBox.a, boundingBox.b, boundingBox.c);
        Vector size = new Vector(boundingBox.d, boundingBox.e, boundingBox.f);
        return new BoundingBox(position, size);
    }

    public void setBoundingBox(Entity entity, BoundingBox boundingBox) {
        Vector low = boundingBox.getLow();
        Vector high = boundingBox.getHigh();
        ((CraftEntity)entity).getHandle().a(new AxisAlignedBB(low.getX(), low.getY(), low.getZ(), high.getX(), high.getY(), high.getZ()));
    }

    public boolean isChestedHorse(Entity horse) {
        return horse instanceof ChestedHorse;
    }

    public boolean isCarryingChest(Entity horse) {
        return horse instanceof ChestedHorse && ((ChestedHorse)horse).isCarryingChest();
    }

    public void setCarryingChest(Entity horse, boolean carrying) {
        if (horse instanceof ChestedHorse) {
            ((ChestedHorse)horse).setCarryingChest(carrying);
        }
    }

    public void setTicksLived(Entity entity, int ticks) {
        ((CraftEntity)entity).getHandle().R = ticks;
        if (entity instanceof CraftFallingBlock) {
            ((CraftFallingBlock)entity).getHandle().b = ticks;
        } else if (entity instanceof CraftItem) {
            ((EntityItem)((CraftItem)entity).getHandle()).ao = ticks;
        }
    }

    public int getShulkerPeek(Entity entity) {
        return ((CraftShulker)entity).getHandle().getPeek();
    }

    public void setShulkerPeek(Entity entity, int peek) {
        ((CraftShulker)entity).getHandle().setPeek(peek);
    }

    public void setHeadAngle(Entity entity, float angle) {
        EntityLiving handle = ((CraftLivingEntity)entity).getHandle();
        handle.aZ = angle;
        handle.setHeadRotation(angle);
    }

    public void setGhastAttacking(Entity entity, boolean attacking) {
        ((CraftGhast)entity).getHandle().v(attacking);
    }

    public void setEndermanAngry(Entity entity, boolean angry) {
        ((CraftEnderman)entity).getHandle().getDataWatcher().set(ENTITY_ENDERMAN_DATAWATCHER_SCREAMING, (Object)angry);
    }

    public static DamageSource getSourceFor(net.minecraft.world.entity.Entity nmsSource, EntityDamageEvent.DamageCause cause) {
        DamageSource src = DamageSource.n;
        if (nmsSource != null) {
            if (nmsSource instanceof EntityHuman) {
                src = DamageSource.playerAttack((EntityHuman)((EntityHuman)nmsSource));
            } else if (nmsSource instanceof EntityLiving) {
                src = DamageSource.mobAttack((EntityLiving)((EntityLiving)nmsSource));
            }
        }
        if (cause == null) {
            return src;
        }
        switch (cause) {
            case CONTACT: {
                return DamageSource.j;
            }
            case ENTITY_ATTACK: {
                return DamageSource.mobAttack((EntityLiving)(nmsSource instanceof EntityLiving ? (EntityLiving)nmsSource : null));
            }
            case ENTITY_SWEEP_ATTACK: {
                if (src != DamageSource.n) {
                    src.sweep();
                }
                return src;
            }
            case PROJECTILE: {
                return DamageSource.projectile((net.minecraft.world.entity.Entity)nmsSource, nmsSource.getBukkitEntity() instanceof Projectile && ((Projectile)nmsSource.getBukkitEntity()).getShooter() instanceof Entity ? ((CraftEntity)((Projectile)nmsSource.getBukkitEntity()).getShooter()).getHandle() : null);
            }
            case SUFFOCATION: {
                return DamageSource.f;
            }
            case FALL: {
                return DamageSource.k;
            }
            case FIRE: {
                return DamageSource.a;
            }
            case FIRE_TICK: {
                return DamageSource.c;
            }
            case MELTING: {
                return CraftEventFactory.MELTING;
            }
            case LAVA: {
                return DamageSource.d;
            }
            case DROWNING: {
                return DamageSource.h;
            }
            case BLOCK_EXPLOSION: {
                return DamageSource.d(nmsSource instanceof TNTPrimed && ((TNTPrimed)nmsSource).getSource() instanceof EntityLiving ? (EntityLiving)((TNTPrimed)nmsSource).getSource() : null);
            }
            case ENTITY_EXPLOSION: {
                return DamageSource.d((EntityLiving)(nmsSource instanceof EntityLiving ? (EntityLiving)nmsSource : null));
            }
            case VOID: {
                return DamageSource.m;
            }
            case LIGHTNING: {
                return DamageSource.b;
            }
            case STARVATION: {
                return DamageSource.i;
            }
            case POISON: {
                return CraftEventFactory.POISON;
            }
            case MAGIC: {
                return DamageSource.o;
            }
            case WITHER: {
                return DamageSource.p;
            }
            case FALLING_BLOCK: {
                return DamageSource.r;
            }
            case THORNS: {
                return DamageSource.a((net.minecraft.world.entity.Entity)nmsSource);
            }
            case DRAGON_BREATH: {
                return DamageSource.s;
            }
            case CUSTOM: {
                return DamageSource.n;
            }
            case FLY_INTO_WALL: {
                return DamageSource.l;
            }
            case HOT_FLOOR: {
                return DamageSource.e;
            }
            case CRAMMING: {
                return DamageSource.g;
            }
            case DRYOUT: {
                return DamageSource.t;
            }
        }
        return new FakeDamageSrc(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void damage(LivingEntity target, float amount, Entity source, EntityDamageEvent.DamageCause cause) {
        net.minecraft.world.entity.Entity nmsSource;
        if (target == null) {
            return;
        }
        EntityLiving nmsTarget = ((CraftLivingEntity)target).getHandle();
        CraftEventFactory.entityDamage = nmsSource = source == null ? null : ((CraftEntity)source).getHandle();
        try {
            DamageSource src = EntityHelperImpl.getSourceFor(nmsSource, cause);
            if (src instanceof FakeDamageSrc) {
                src = ((FakeDamageSrc)src).real;
                EntityDamageEvent ede = EntityHelperImpl.fireFakeDamageEvent((Entity)target, (Entity)source, (EntityDamageEvent.DamageCause)cause, (float)amount);
                if (ede.isCancelled()) {
                    return;
                }
            }
            nmsTarget.damageEntity(src, amount);
        }
        finally {
            CraftEventFactory.entityDamage = null;
        }
    }

    public void setLastHurtBy(LivingEntity mob, LivingEntity damager) {
        ((CraftLivingEntity)mob).getHandle().setLastDamager(((CraftLivingEntity)damager).getHandle());
    }

    public void setFallingBlockType(FallingBlock entity, BlockData block) {
        IBlockData state = ((CraftBlockData)block).getState();
        EntityFallingBlock nmsEntity = ((CraftFallingBlock)entity).getHandle();
        try {
            FALLINGBLOCK_TYPE_SETTER.invoke(nmsEntity, state);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public EntityTag getMobSpawnerDisplayEntity(CreatureSpawner spawner) {
        TileEntityMobSpawner nmsSpawner = (TileEntityMobSpawner)BlockHelperImpl.getTE((CraftCreatureSpawner)spawner);
        net.minecraft.world.entity.Entity nmsEntity = nmsSpawner.getSpawner().a((net.minecraft.world.level.World)((CraftWorld)spawner.getWorld()).getHandle());
        return new EntityTag((Entity)nmsEntity.getBukkitEntity());
    }

    public void setFireworkLifetime(Firework firework, int ticks) {
        ((CraftFirework)firework).getHandle().f = ticks;
    }

    public int getFireworkLifetime(Firework firework) {
        return ((CraftFirework)firework).getHandle().f;
    }

    public static class FakeDamageSrc
    extends DamageSource {
        public DamageSource real;

        public FakeDamageSrc(DamageSource src) {
            super("fake");
            this.real = src;
        }
    }
}

