/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;

public abstract class AbstractCommand {
    public static HashSet<String> noErrorCommandNames = new HashSet<String>(Arrays.asList("case", "default"));
    public String syntax = "No usage defined! See documentation for more information!";
    public List<String> docFlagArgs = new ArrayList<String>();
    public List<String> docPrefixes = new ArrayList<String>();
    private boolean preparseArgs = true;
    public boolean forceHold = false;
    public int minimumArguments = 0;
    public int maximumArguments = Integer.MAX_VALUE;
    public HashSet<String> prefixesHandled = new HashSet();
    public HashSet<String> rawValuesHandled = new HashSet();
    public HashMap<String, String> prefixRemapper = new HashMap();
    public boolean allowedDynamicPrefixes = false;
    public boolean isProcedural = false;
    protected String name;

    public void setSyntax(String syntax) {
        this.syntax = syntax;
        int firstSpace = syntax.indexOf(32);
        if (firstSpace < 0) {
            return;
        }
        String cleaned = syntax.substring(firstSpace).replace("/", " ");
        cleaned = cleaned.replace("[", "").replace("]", "").replace("(", "").replace(")", "").replace("{", "").replace("}", "");
        List<String> args = CoreUtilities.split(cleaned, ' ');
        for (String arg : args) {
            if (arg.isEmpty()) continue;
            int colonIndex = arg.indexOf(58);
            if (colonIndex > 0) {
                String prefix = arg.substring(0, colonIndex);
                if (prefix.contains("<")) continue;
                this.docPrefixes.add(prefix);
                continue;
            }
            if (arg.contains("<") || arg.contains("|")) continue;
            this.docFlagArgs.add(arg);
        }
        if (Debug.verbose) {
            Debug.log("Command syntax '" + syntax + "' parsed to flat args: ( " + String.join((CharSequence)", ", this.docFlagArgs) + " ) and prefixes ( " + String.join((CharSequence)", ", this.docPrefixes) + " ).");
        }
    }

    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
    }

    public void addRemappedPrefixes(String realName, String ... alts) {
        this.prefixesHandled.add(realName);
        this.prefixesHandled.addAll(Arrays.asList(alts));
        for (String alt : alts) {
            this.prefixRemapper.put(alt, realName);
        }
    }

    public void setPrefixesHandled(String ... prefixes) {
        this.prefixesHandled.addAll(Arrays.asList(prefixes));
    }

    public void setRawValuesHandled(String ... values) {
        this.rawValuesHandled.addAll(Arrays.asList(values));
    }

    public void setBooleansHandled(String ... boolNames) {
        this.setPrefixesHandled(boolNames);
        this.setRawValuesHandled(boolNames);
    }

    public static String db(String prefix, boolean value) {
        return "<G>" + prefix + "='<Y>" + value + "<G>'  ";
    }

    public static String db(String prefix, Object value) {
        if (value == null) {
            return "";
        }
        return ArgumentHelper.debugObj(prefix, value);
    }

    public void setRequiredArguments(int min, int max) {
        this.minimumArguments = min;
        this.maximumArguments = max == -1 ? Integer.MAX_VALUE : max;
    }

    public void setParseArgs(boolean parse) {
        this.preparseArgs = parse;
    }

    public boolean shouldPreParse() {
        return this.preparseArgs;
    }

    public void setName(String commandName) {
        this.name = commandName.toUpperCase();
    }

    @Deprecated
    public AbstractCommand as(String commandName) {
        this.setName(commandName);
        DenizenCore.commandRegistry.register(this.name, this);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getUsageHint() {
        return this.syntax;
    }

    public void onDisable() {
    }

    @Deprecated
    public void withOptions(String usageHint, int numberOfRequiredArgs) {
        this.minimumArguments = numberOfRequiredArgs;
        this.setSyntax(usageHint);
    }

    public abstract void execute(ScriptEntry var1);

    public abstract void parseArgs(ScriptEntry var1) throws InvalidArgumentsException;
}

