/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.EnchantmentTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemEnchantments
implements Property {
    public static final String[] handledTags = new String[]{"is_enchanted", "enchantments", "enchantment_map", "enchantment_types"};
    public static final String[] handledMechs = new String[]{"remove_enchantments", "enchantments"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag;
    }

    public static ItemEnchantments getFrom(ObjectTag _item) {
        if (!ItemEnchantments.describes(_item)) {
            return null;
        }
        return new ItemEnchantments((ItemTag)_item);
    }

    private ItemEnchantments(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("is_enchanted")) {
            return new ElementTag(this.getEnchantments().size() > 0).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("enchantments.with_levels")) {
            Deprecations.itemEnchantmentTags.warn(attribute.context);
            Set<Map.Entry<Enchantment, Integer>> enchantments = this.getEnchantments();
            ListTag enchants = new ListTag();
            for (Map.Entry<Enchantment, Integer> enchantment : enchantments) {
                enchants.add(new EnchantmentTag(enchantment.getKey()).getCleanName() + "," + enchantment.getValue());
            }
            return enchants.getObjectAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("enchantments.levels")) {
            Deprecations.itemEnchantmentTags.warn(attribute.context);
            Set<Map.Entry<Enchantment, Integer>> enchantments = this.getEnchantments();
            ListTag enchants = new ListTag();
            for (Map.Entry<Enchantment, Integer> enchantment : enchantments) {
                enchants.add(String.valueOf(enchantment.getValue()));
            }
            return enchants.getObjectAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("enchantments.level") && attribute.hasContext(2)) {
            Deprecations.itemEnchantmentTags.warn(attribute.context);
            Set<Map.Entry<Enchantment, Integer>> enchantments = this.getEnchantments();
            if (enchantments.size() > 0) {
                for (Map.Entry<Enchantment, Integer> enchantment : enchantments) {
                    if (!enchantment.getKey().getName().equalsIgnoreCase(attribute.getContext(2)) && !new EnchantmentTag(enchantment.getKey()).getCleanName().equalsIgnoreCase(attribute.getContext(2))) continue;
                    return new ElementTag(enchantment.getValue()).getObjectAttribute(attribute.fulfill(2));
                }
            }
            return new ElementTag(0).getObjectAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("enchantment_types")) {
            Set<Map.Entry<Enchantment, Integer>> enchantments = this.getEnchantments();
            ListTag enchants = new ListTag();
            for (Map.Entry<Enchantment, Integer> enchantment : enchantments) {
                enchants.addObject(new EnchantmentTag(enchantment.getKey()));
            }
            return enchants.getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("enchantments")) {
            Deprecations.itemEnchantmentsLegacy.warn(attribute.context);
            Set<Map.Entry<Enchantment, Integer>> enchantments = this.getEnchantments();
            ListTag enchants = new ListTag();
            for (Map.Entry<Enchantment, Integer> enchantment : enchantments) {
                enchants.add(new EnchantmentTag(enchantment.getKey()).getCleanName());
            }
            return enchants.getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("enchantment_map")) {
            return this.getEnchantmentMap().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public MapTag getEnchantmentMap() {
        MapTag enchants = new MapTag();
        for (Map.Entry<Enchantment, Integer> enchantment : this.getEnchantments()) {
            enchants.putObject(new EnchantmentTag(enchantment.getKey()).getCleanName(), new ElementTag(enchantment.getValue()));
        }
        return enchants;
    }

    public Set<Map.Entry<Enchantment, Integer>> getEnchantments() {
        if (this.item.getItemStack().getEnchantments().size() > 0) {
            return this.item.getItemStack().getEnchantments().entrySet();
        }
        if (this.item.getItemMeta() instanceof EnchantmentStorageMeta) {
            return ((EnchantmentStorageMeta)this.item.getItemMeta()).getStoredEnchants().entrySet();
        }
        return new HashSet<Map.Entry<Enchantment, Integer>>();
    }

    @Override
    public String getPropertyString() {
        MapTag map = this.getEnchantmentMap();
        if (map.map.isEmpty()) {
            return null;
        }
        return map.toString();
    }

    @Override
    public String getPropertyId() {
        return "enchantments";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        block23: {
            if (mechanism.matches("remove_enchantments")) {
                if (mechanism.hasValue()) {
                    List<EnchantmentTag> toRemove = mechanism.valueAsType(ListTag.class).filter(EnchantmentTag.class, mechanism.context);
                    if (this.item.getBukkitMaterial() == Material.ENCHANTED_BOOK) {
                        EnchantmentStorageMeta meta = (EnchantmentStorageMeta)this.item.getItemMeta();
                        for (EnchantmentTag enchantmentTag : toRemove) {
                            meta.removeStoredEnchant(enchantmentTag.enchantment);
                        }
                        this.item.setItemMeta((ItemMeta)meta);
                    } else {
                        for (EnchantmentTag enchantmentTag : toRemove) {
                            this.item.getItemStack().removeEnchantment(enchantmentTag.enchantment);
                        }
                        this.item.resetCache();
                    }
                } else if (this.item.getBukkitMaterial() == Material.ENCHANTED_BOOK) {
                    EnchantmentStorageMeta meta = (EnchantmentStorageMeta)this.item.getItemMeta();
                    for (Enchantment enchantment : meta.getStoredEnchants().keySet()) {
                        meta.removeStoredEnchant(enchantment);
                    }
                    this.item.setItemMeta((ItemMeta)meta);
                } else {
                    for (Enchantment ench : this.item.getItemStack().getEnchantments().keySet()) {
                        this.item.getItemStack().removeEnchantment(ench);
                    }
                    this.item.resetCache();
                }
            }
            if (!mechanism.matches("enchantments")) break block23;
            String val = mechanism.getValue().asString();
            if (val.startsWith("map@") || val.startsWith("[") || val.contains("=") && !val.contains(",")) {
                MapTag map = mechanism.valueAsType(MapTag.class);
                for (Map.Entry<StringHolder, ObjectTag> entry : map.map.entrySet()) {
                    Enchantment ench = EnchantmentTag.valueOf((String)entry.getKey().low, (TagContext)mechanism.context).enchantment;
                    int level = entry.getValue().asType(ElementTag.class, mechanism.context).asInt();
                    if (ench != null) {
                        if (this.item.getBukkitMaterial() == Material.ENCHANTED_BOOK) {
                            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)this.item.getItemMeta();
                            meta.addStoredEnchant(ench, level, true);
                            this.item.setItemMeta((ItemMeta)meta);
                            continue;
                        }
                        this.item.getItemStack().addUnsafeEnchantment(ench, level);
                        this.item.resetCache();
                        continue;
                    }
                    mechanism.echoError("Unknown enchantment '" + entry.getKey().str + "'");
                }
            } else {
                for (String string : mechanism.valueAsType(ListTag.class)) {
                    if (!string.contains(",")) {
                        mechanism.echoError("Invalid enchantment format, use name,level|...");
                        continue;
                    }
                    String[] stringArray = string.split(",", 2);
                    try {
                        Enchantment ench = EnchantmentTag.valueOf((String)stringArray[0], (TagContext)mechanism.context).enchantment;
                        if (ench != null) {
                            if (this.item.getBukkitMaterial() == Material.ENCHANTED_BOOK) {
                                EnchantmentStorageMeta meta = (EnchantmentStorageMeta)this.item.getItemMeta();
                                meta.addStoredEnchant(ench, Integer.valueOf(stringArray[1]).intValue(), true);
                                this.item.setItemMeta((ItemMeta)meta);
                                continue;
                            }
                            this.item.getItemStack().addUnsafeEnchantment(ench, Integer.valueOf(stringArray[1]).intValue());
                            this.item.resetCache();
                            continue;
                        }
                        mechanism.echoError("Unknown enchantment '" + stringArray[0] + "'");
                    }
                    catch (NullPointerException e) {
                        mechanism.echoError("Unknown enchantment '" + stringArray[0] + "'");
                    }
                    catch (NumberFormatException ex) {
                        mechanism.echoError("Cannot apply enchantment '" + stringArray[0] + "': '" + stringArray[1] + "' is not a valid integer!");
                        if (!Debug.verbose) continue;
                        Debug.echoError(ex);
                    }
                }
            }
        }
    }
}

