/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.nbt.CustomNBT;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemCanPlaceOn
implements Property {
    public static final String[] handledTags = new String[]{"can_place_on"};
    public static final String[] handledMechs = new String[]{"can_place_on"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag;
    }

    public static ItemCanPlaceOn getFrom(ObjectTag item) {
        if (!ItemCanPlaceOn.describes(item)) {
            return null;
        }
        return new ItemCanPlaceOn((ItemTag)item);
    }

    private ItemCanPlaceOn(ItemTag item) {
        this.item = item;
    }

    private ListTag getMaterials() {
        ItemStack itemStack = this.item.getItemStack();
        List<Material> materials = CustomNBT.getNBTMaterials(itemStack, "CanPlaceOn");
        if (materials != null && !materials.isEmpty()) {
            ListTag list = new ListTag();
            for (Material material : materials) {
                list.addObject(new MaterialTag(material));
            }
            return list;
        }
        return null;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        ListTag materials;
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("can_place_on") && (materials = this.getMaterials()) != null) {
            return materials.getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        ListTag materials = this.getMaterials();
        return materials != null ? materials.identify() : null;
    }

    @Override
    public String getPropertyId() {
        return "can_place_on";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("can_place_on")) {
            if (this.item.getMaterial().getMaterial() == Material.AIR) {
                mechanism.echoError("Cannot apply NBT to AIR!");
                return;
            }
            ItemStack itemStack = this.item.getItemStack();
            if (mechanism.hasValue()) {
                List<Material> materials = mechanism.valueAsType(ListTag.class).filter(MaterialTag.class, mechanism.context).stream().map(MaterialTag::getMaterial).collect(Collectors.toList());
                itemStack = CustomNBT.setNBTMaterials(itemStack, "CanPlaceOn", materials);
            } else {
                itemStack = CustomNBT.clearNBT(itemStack, "CanPlaceOn");
            }
            this.item.setItemStack(itemStack);
        }
    }
}

