/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.npc.traits.InvisibleTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.ArmorStand;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class InvisibleCommand
extends AbstractCommand {
    public InvisibleCommand() {
        this.setName("invisible");
        this.setSyntax("invisible [<entity>] (state:true/false/toggle)");
        this.setRequiredArguments(1, 2);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("state") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("state", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matches("player") && Utilities.entryHasPlayer(scriptEntry)) {
                scriptEntry.addObject("target", Utilities.getEntryPlayer(scriptEntry).getDenizenEntity());
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matches("npc") && Utilities.entryHasNPC(scriptEntry)) {
                scriptEntry.addObject("target", Utilities.getEntryNPC(scriptEntry).getDenizenEntity());
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matchesArgumentType(EntityTag.class)) {
                scriptEntry.addObject("target", arg.asType(EntityTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("state")) {
            scriptEntry.addObject("state", new ElementTag("TRUE"));
        }
        if (!scriptEntry.hasObject("target") || !((EntityTag)scriptEntry.getObjectTag("target")).isValid()) {
            throw new InvalidArgumentsException("Must specify a valid target!");
        }
    }

    public void setInvisible(EntityTag entity, boolean visible) {
        if (entity.getBukkitEntity() instanceof ArmorStand) {
            ((ArmorStand)entity.getBukkitEntity()).setVisible(visible);
        } else if (entity.isLivingEntity() && !entity.isFake) {
            if (visible) {
                entity.getLivingEntity().removePotionEffect(PotionEffectType.INVISIBILITY);
            } else {
                new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1).apply(entity.getLivingEntity());
            }
        } else {
            NMSHandler.getEntityHelper().setInvisible(entity.getBukkitEntity(), !visible);
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag state = scriptEntry.getElement("state");
        EntityTag target = (EntityTag)scriptEntry.getObjectTag("target");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), state, target);
        }
        if (target.isCitizensNPC()) {
            NPC npc = target.getDenizenNPC().getCitizen();
            if (!npc.hasTrait(InvisibleTrait.class)) {
                npc.addTrait(InvisibleTrait.class);
            }
            InvisibleTrait trait = (InvisibleTrait)npc.getOrAddTrait(InvisibleTrait.class);
            switch (Action.valueOf(state.asString().toUpperCase())) {
                case FALSE: {
                    trait.setInvisible(false);
                    break;
                }
                case TRUE: {
                    trait.setInvisible(true);
                    break;
                }
                case TOGGLE: {
                    trait.toggle();
                }
            }
        } else {
            switch (Action.valueOf(state.asString().toUpperCase())) {
                case FALSE: {
                    this.setInvisible(target, true);
                    break;
                }
                case TRUE: {
                    this.setInvisible(target, false);
                    break;
                }
                case TOGGLE: {
                    if (target.getBukkitEntity() instanceof ArmorStand) {
                        this.setInvisible(target, !((ArmorStand)target.getBukkitEntity()).isVisible());
                        break;
                    }
                    this.setInvisible(target, target.getLivingEntity().hasPotionEffect(PotionEffectType.INVISIBILITY));
                }
            }
        }
    }

    static enum Action {
        TRUE,
        FALSE,
        TOGGLE;

    }
}

