/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.properties;

import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;

public class PaperWorldProperties
implements Property {
    public static final String[] handledMechs = new String[]{"view_distance", "no_tick_view_distance"};
    WorldTag world;

    public static boolean describes(ObjectTag world) {
        return world instanceof WorldTag;
    }

    public static PaperWorldProperties getFrom(ObjectTag world) {
        if (!PaperWorldProperties.describes(world)) {
            return null;
        }
        return new PaperWorldProperties((WorldTag)world);
    }

    private PaperWorldProperties(WorldTag world) {
        this.world = world;
    }

    public String getPropertyString() {
        return null;
    }

    public String getPropertyId() {
        return "PaperWorldProperties";
    }

    public static void registerTags() {
        PropertyParser.registerTag(ElementTag.class, (String)"view_distance", (attribute, world) -> new ElementTag(world.world.getWorld().getViewDistance()), (String[])new String[0]);
        PropertyParser.registerTag(ElementTag.class, (String)"no_tick_view_distance", (attribute, world) -> new ElementTag(world.world.getWorld().getNoTickViewDistance()), (String[])new String[0]);
    }

    public void adjust(Mechanism mechanism) {
        int distance;
        if (mechanism.matches("view_distance") && mechanism.requireInteger()) {
            distance = mechanism.getValue().asInt();
            if (distance < 2 || distance > 32) {
                Debug.echoError((String)"View distance must be a number from 2 to 32!");
            } else {
                this.world.getWorld().setViewDistance(distance);
            }
        }
        if (mechanism.matches("no_tick_view_distance")) {
            if (!mechanism.hasValue()) {
                this.world.getWorld().setNoTickViewDistance(-1);
            } else if (mechanism.requireInteger()) {
                distance = mechanism.getValue().asInt();
                if (distance < 2 || distance > 32) {
                    Debug.echoError((String)"View distance must be a number from 2 to 32!");
                } else {
                    this.world.getWorld().setNoTickViewDistance(distance);
                }
            }
        }
    }
}

