/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;

public class ScriptHelper {
    public static ArrayList<YamlConfiguration> _yamlScripts;
    private static boolean hadError;
    private static HashMap<String, String> scriptSources;
    private static HashMap<String, String> scriptOriginalNames;
    public static CharsetDecoder encoding;

    public static void reloadScripts() {
        try {
            _yamlScripts = ScriptHelper.buildScriptList();
        }
        catch (Exception ex) {
            hadError = true;
            Debug.echoError("Could not load scripts!");
            Debug.echoError(ex);
            _yamlScripts = new ArrayList();
        }
        ScriptRegistry.buildCoreYamlScriptContainers(_yamlScripts);
    }

    public static boolean hadError() {
        return hadError;
    }

    public static void resetError() {
        hadError = false;
    }

    public static void setHadError() {
        hadError = true;
    }

    public static String getSource(String script) {
        return scriptSources.get(script.toUpperCase());
    }

    public static String getOriginalName(String script) {
        return scriptOriginalNames.get(script.toUpperCase());
    }

    public static String clearComments(String filename, String input, boolean trackSources) {
        StringBuilder result = new StringBuilder(input.length());
        String[] lines = input.replace("\t", "    ").replace("\r", "").split("\n");
        boolean hasAnyScript = false;
        for (int lineNum = 0; lineNum < lines.length; ++lineNum) {
            String trimmedLine = lines[lineNum].trim();
            String trimStart = lines[lineNum].replaceAll("^[\\s]+", "");
            if (trackSources && !trimmedLine.startsWith("#") && trimStart.length() == lines[lineNum].length() && trimmedLine.endsWith(":") && trimmedLine.length() > 1) {
                String name = trimmedLine.substring(0, trimmedLine.length() - 1).replace('\"', '\'').replace("'", "");
                scriptSources.put(name.toUpperCase(), filename);
                scriptOriginalNames.put(name.toUpperCase(), name);
                result.append(name.toUpperCase()).append(":\n");
                hasAnyScript = true;
                continue;
            }
            if (!trimmedLine.startsWith("#")) {
                if (trackSources && !hasAnyScript && trimmedLine.endsWith(":")) {
                    Debug.echoError("Script '<Y>" + filename + "<W>' is broken: script container title has spaces in front.");
                    hasAnyScript = true;
                }
                if ((trimmedLine.startsWith("}") || trimmedLine.startsWith("{") || trimmedLine.startsWith("else")) && !trimmedLine.endsWith(":")) {
                    result.append(' ').append(lines[lineNum].replace('\u0000', ' ').replace(": ", "<&co>").replace("#", "<&ns>")).append("\n");
                    continue;
                }
                String curLine = lines[lineNum].replace('\u0000', ' ');
                boolean endsColon = trimmedLine.endsWith(":");
                boolean startsDash = trimmedLine.startsWith("-");
                if (!endsColon && startsDash) {
                    curLine = curLine.replace(": ", "<&co> ");
                    curLine = curLine.replace("#", "<&ns>");
                } else if (endsColon && !startsDash) {
                    if (curLine.contains(".")) {
                        curLine = curLine.replace("&", "&amp").replace(".", "&dot");
                    }
                } else if (!startsDash && trimmedLine.contains(": &")) {
                    int colon = curLine.indexOf(58);
                    curLine = curLine.substring(0, colon) + ": \"" + curLine.substring(colon + 2).replace("\"", "<&dq>") + "\"";
                }
                if (trimmedLine.startsWith("- ") && !trimmedLine.startsWith("- \"") && !trimmedLine.startsWith("- '")) {
                    int dashIndex = curLine.indexOf(45);
                    curLine = curLine.substring(0, dashIndex + 1) + " " + ScriptBuilder.LINE_PREFIX_CHAR + (lineNum + 1) + ScriptBuilder.LINE_PREFIX_CHAR + curLine.substring(dashIndex + 1);
                }
                result.append(curLine).append("\n");
                continue;
            }
            result.append("\n");
        }
        result.append("\n");
        return result.toString();
    }

    public static String convertStreamToString(InputStream is) {
        return ScriptHelper.convertStreamToString(is, false);
    }

    public static String convertStreamToString(InputStream is, boolean defaultUTF8) {
        Scanner s = encoding == null && !defaultUTF8 ? new Scanner(is) : new Scanner(new InputStreamReader(is, encoding == null ? StandardCharsets.UTF_8.newDecoder() : encoding));
        s.useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YamlConfiguration loadConfig(String filename, InputStream resource) throws IOException {
        try {
            String script = ScriptHelper.clearComments(filename, ScriptHelper.convertStreamToString(resource, filename.endsWith(".dsc")), true);
            YamlConfiguration yamlConfiguration = YamlConfiguration.load(script);
            return yamlConfiguration;
        }
        finally {
            resource.close();
        }
    }

    private static ArrayList<YamlConfiguration> buildScriptList() {
        scriptSources.clear();
        try {
            File file = DenizenCore.implementation.getScriptFolder();
            if (!file.exists()) {
                Debug.echoError("No script folder found, please create one.");
                hadError = true;
                return new ArrayList<YamlConfiguration>();
            }
            List<File> files = CoreUtilities.listDScriptFiles(file);
            if (files.size() > 0) {
                ArrayList<YamlConfiguration> outList = new ArrayList<YamlConfiguration>();
                ArrayList scriptNames = new ArrayList(files.size() * 2);
                for (File f : files) {
                    String fileName = f.getAbsolutePath().substring(file.getAbsolutePath().length());
                    if (Debug.showLoading) {
                        Debug.log("Processing '" + fileName + "'... ");
                    }
                    try {
                        String saved;
                        YamlConfiguration yaml = ScriptHelper.loadConfig(f.getAbsolutePath(), new FileInputStream(f));
                        String string = saved = yaml != null ? yaml.saveToString(false) : null;
                        if (saved != null && saved.length() > 0) {
                            outList.add(yaml);
                            continue;
                        }
                        Debug.echoError("Error parsing '<Y>" + fileName + "<W>'! This script has been skipped. No internal error - is the file empty?");
                        hadError = true;
                    }
                    catch (Exception e) {
                        Debug.echoError("Error parsing '<Y>" + fileName + "<W>'!");
                        hadError = true;
                        Debug.echoError(e);
                    }
                }
                if (Debug.showLoading) {
                    Debug.echoApproval("All scripts loaded!");
                }
                return outList;
            }
            Debug.log("No scripts in /plugins/Denizen/scripts/ to load!");
            hadError = true;
        }
        catch (Exception e) {
            Debug.echoError("No script folder found in " + DenizenCore.implementation.getScriptFolder());
            hadError = true;
            Debug.echoError(e);
        }
        return new ArrayList<YamlConfiguration>();
    }

    static {
        hadError = false;
        scriptSources = new HashMap();
        scriptOriginalNames = new HashMap();
        encoding = null;
    }
}

