/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;

public class ProjectileHitsBlockScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ProjectileHitsBlockScriptEvent instance;
    public EntityTag projectile;
    public EntityTag shooter;
    public LocationTag location;
    private MaterialTag material;
    public ProjectileHitEvent event;

    public ProjectileHitsBlockScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        String cmd = path.eventArgLowerAt(1);
        if (!cmd.equals("hits") && !cmd.equals("shoots")) {
            return false;
        }
        if (!ProjectileHitsBlockScriptEvent.couldMatchEntity(path.eventArgLowerAt(0))) {
            return false;
        }
        return ProjectileHitsBlockScriptEvent.couldMatchBlock(path.eventArgLowerAt(2));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String cmd = path.eventArgLowerAt(1);
        String pTest = "";
        if (cmd.equals("hits")) {
            pTest = path.eventArgLowerAt(0);
        } else if (cmd.equals("shoots")) {
            if (this.shooter == null || !ProjectileHitsBlockScriptEvent.tryEntity(this.shooter, path.eventArgLowerAt(0))) {
                return false;
            }
            if (path.eventArgLowerAt(3).equals("with")) {
                pTest = path.eventArgLowerAt(4);
            }
        }
        if (!(pTest.isEmpty() || pTest.equals("projectile") || ProjectileHitsBlockScriptEvent.tryEntity(this.projectile, pTest))) {
            return false;
        }
        if (path.switches.containsKey("with") && !ProjectileHitsBlockScriptEvent.tryEntity(this.projectile, path.switches.get("with"))) {
            return false;
        }
        if (!ProjectileHitsBlockScriptEvent.tryMaterial(this.material, path.eventArgLowerAt(2))) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "ProjectileHitsBlock";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.shooter);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("projectile")) {
            return this.projectile.getDenizenObject();
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("hit_face") && this.event.getHitBlockFace() != null) {
            return new LocationTag(this.event.getHitBlockFace().getDirection());
        }
        if (name.equals("shooter") && this.shooter != null) {
            return this.shooter.getDenizenObject();
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onProjectileHits(ProjectileHitEvent event) {
        this.projectile = new EntityTag((Entity)event.getEntity());
        if (this.projectile.getLocation() == null) {
            return;
        }
        if (Double.isNaN(this.projectile.getLocation().getDirection().normalize().getX())) {
            return;
        }
        Block block = event.getHitBlock();
        if (block == null) {
            return;
        }
        this.material = new MaterialTag(block);
        this.shooter = this.projectile.getShooter();
        this.location = new LocationTag(block.getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

