/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.exceptions.ScriptEntryCreationException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.BracedCommand;
import net.aufdemrand.denizencore.scripts.commands.Holdable;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class ScriptEntry
implements Cloneable,
Debuggable {
    public List<Argument> args_cur = null;
    public List<aH.Argument> aHArgs = null;
    public List<String> args = null;
    public List<dObject> processed_arguments = null;
    public ScriptEntryData entryData = null;
    private ScriptQueue queue = null;
    public ScriptEntryInternal internal = null;
    private Map<String, Object> objects = new HashMap<String, Object>();
    public static final aH.Argument NULL_ARGUMENT = new aH.Argument("null_trick", "null_trick");
    public boolean broken = false;
    private ScriptEntry owner = null;
    private Object data;
    public boolean forceInstant = false;
    public boolean isFinished = false;
    public List<String> tracked_objects = new ArrayList<String>();
    public boolean fallbackDebug = true;
    public Boolean shouldDebugBool = null;

    public List<BracedCommand.BracedData> getBracedSet() {
        return this.internal.bracedSet;
    }

    public void setBracedSet(List<BracedCommand.BracedData> set) {
        this.internal.bracedSet = set;
    }

    public void regenerateArgsCur() {
        this.args_cur = new ArrayList<Argument>(this.internal.args_ref);
        for (int i : this.internal.processArgs) {
            Argument arg = this.args_cur.get(i);
            arg.value = new ArrayList<TagManager.ParseableTagPiece>(arg.value);
            arg.aHArg = this.aHArgs.get(i);
        }
    }

    public void generateAHArgs() {
        this.aHArgs = new ArrayList<aH.Argument>(this.internal.args_ref.size());
        for (int i = 0; i < this.internal.args_ref.size(); ++i) {
            this.aHArgs.add(this.internal.args_ref.get(i) == null ? NULL_ARGUMENT : this.internal.args_ref.get((int)i).aHArg);
        }
        for (int i : this.internal.processArgs) {
            Argument arg = this.internal.args_ref.get(i);
            this.aHArgs.set(i, arg.aHArg.needsFill || arg.aHArg.hasSpecialPrefix || this.internal.hasOldDefs && arg.aHArg.raw_value.indexOf(37) != -1 ? arg.aHArg.clone() : arg.aHArg);
        }
    }

    public ScriptEntry clone() throws CloneNotSupportedException {
        ScriptEntry se = (ScriptEntry)super.clone();
        se.objects = new HashMap<String, Object>();
        se.processed_arguments = this.processed_arguments == null ? null : new ArrayList<dObject>(this.processed_arguments);
        se.args = new ArrayList<String>(this.args);
        se.entryData = this.entryData.clone();
        return se;
    }

    public List<Object> getInsideList() {
        return this.internal.insideList;
    }

    public ScriptEntry(String command, String[] arguments, ScriptContainer script) throws ScriptEntryCreationException {
        this(command, arguments, script, null);
    }

    public void crunchInto(Argument argVal, String arg, TagContext refContext) {
        int indEnd;
        if (arg.indexOf(37) != -1) {
            this.internal.hasOldDefs = true;
            argVal.value = new LinkedList<TagManager.ParseableTagPiece>();
            TagManager.ParseableTagPiece piece = new TagManager.ParseableTagPiece();
            piece.content = arg;
            argVal.value.add(piece);
        } else {
            argVal.value = TagManager.genChain(arg, refContext);
        }
        boolean isTag = false;
        int indStart = arg.indexOf(60);
        if (indStart >= 0 && (indEnd = arg.lastIndexOf(62)) > indStart) {
            isTag = true;
            this.internal.hasTags = true;
            while (!this.internal.hasInstantTags && indStart >= 0 && indStart + 1 < indEnd) {
                char c = arg.charAt(indStart + 1);
                if (c == '!' || c == '^') {
                    this.internal.hasInstantTags = true;
                }
                indStart = arg.indexOf(60, indStart + 1);
            }
        }
        argVal.aHArg = new aH.Argument(argVal.prefix == null ? null : argVal.prefix.aHArg.raw_value, arg);
        argVal.aHArg.needsFill = isTag;
        argVal.aHArg.hasSpecialPrefix = argVal.prefix != null;
    }

    public ScriptEntry(String command, String[] arguments, ScriptContainer script, List<Object> insides) throws ScriptEntryCreationException {
        if (command == null) {
            throw new ScriptEntryCreationException("dCommand 'name' cannot be null!");
        }
        this.internal = new ScriptEntryInternal();
        this.entryData = DenizenCore.getImplementation().getEmptyScriptEntryData();
        this.internal.command = command.toUpperCase();
        this.internal.insideList = insides;
        if (script != null) {
            this.internal.script = script.getAsScriptArg();
        }
        if (command.length() > 0) {
            if (command.charAt(0) == '^') {
                this.internal.instant = true;
                this.internal.command = command.substring(1);
            } else if (command.charAt(0) == '~') {
                this.internal.command = command.substring(1);
                if (DenizenCore.getCommandRegistry().get(this.internal.command) instanceof Holdable) {
                    this.internal.waitfor = true;
                } else {
                    dB.echoError("The command '" + this.internal.command + "' cannot be waited for!");
                }
            }
            this.internal.actualCommand = DenizenCore.getCommandRegistry().get(this.internal.command);
        } else {
            this.internal.actualCommand = null;
        }
        if (arguments != null) {
            int i;
            this.args = new ArrayList<String>(arguments.length);
            this.internal.preprocArgs = new ArrayList<aH.Argument>();
            int nested_depth = 0;
            for (String arg : arguments) {
                aH.Argument argObj;
                if (arg.equals("{")) {
                    ++nested_depth;
                    this.args.add(arg);
                    continue;
                }
                if (arg.equals("}")) {
                    --nested_depth;
                    this.args.add(arg);
                    continue;
                }
                if (nested_depth > 0) {
                    this.args.add(arg);
                    continue;
                }
                String parg = arg;
                String after = null;
                if (parg.endsWith("{") && !parg.equals("{")) {
                    after = "{";
                    parg = parg.substring(0, parg.length() - 1);
                    dB.echoError("Command '" + command + "' in script '" + (script == null ? "(None)" : script.getName()) + "' has typo: brace written without space... like 'arg{' when it should be 'arg {'.");
                }
                if ((argObj = new aH.Argument(arg)).hasPrefix()) {
                    if (argObj.matchesOnePrefix("unparsed")) {
                        this.args.add(TagManager.escapeOutput(argObj.getValue()));
                    } else if (argObj.matchesOnePrefix("save") || DenizenCore.getImplementation().needsHandleArgPrefix(argObj.prefix)) {
                        this.internal.preprocArgs.add(argObj);
                    } else {
                        this.args.add(arg);
                    }
                } else {
                    this.args.add(parg);
                }
                if (after == null) continue;
                this.args.add(after);
                if (!after.equals("{")) continue;
                ++nested_depth;
                this.args.add(arg);
            }
            this.internal.pre_tagged_args = new ArrayList<String>(this.args);
            nested_depth = 0;
            TagContext refContext = DenizenCore.getImplementation().getTagContext(this);
            this.internal.args_ref = new ArrayList<Argument>(this.args.size());
            ArrayList<Integer> tempProcessArgs = new ArrayList<Integer>();
            for (i = 0; i < this.args.size(); ++i) {
                Argument brace;
                String arg;
                arg = this.args.get(i);
                if (arg.equals("{")) {
                    brace = new Argument();
                    brace.aHArg = new aH.Argument("", "{");
                    this.internal.args_ref.add(brace);
                    ++nested_depth;
                    continue;
                }
                if (arg.equals("}")) {
                    brace = new Argument();
                    brace.aHArg = new aH.Argument("", "}");
                    this.internal.args_ref.add(brace);
                    --nested_depth;
                    continue;
                }
                this.internal.args_ref.add(null);
                if (nested_depth > 0) continue;
                tempProcessArgs.add(i);
                Argument argVal = new Argument();
                this.internal.args_ref.set(i, argVal);
                int colon = TagManager.findColonNotTagNorSpace(arg);
                if (colon > 0) {
                    argVal.prefix = new Argument();
                    this.crunchInto(argVal.prefix, arg.substring(0, colon), refContext);
                    arg = arg.substring(colon + 1);
                }
                this.crunchInto(argVal, arg, refContext);
            }
            this.internal.processArgs = new int[tempProcessArgs.size()];
            for (i = 0; i < tempProcessArgs.size(); ++i) {
                this.internal.processArgs[i] = (Integer)tempProcessArgs.get(i);
            }
            this.objectify();
        } else {
            this.args = new ArrayList<String>();
            this.internal.preprocArgs = new ArrayList<aH.Argument>();
            this.internal.pre_tagged_args = new ArrayList<String>();
            this.internal.processArgs = new int[0];
            this.internal.args_ref = new ArrayList<Argument>();
            this.processed_arguments = new ArrayList<dObject>();
        }
        if (this.internal.actualCommand != null) {
            if (this.internal.actualCommand.getOptions().REQUIRED_ARGS > this.args.size()) {
                this.broken = true;
            }
            if (this.internal.actualCommand instanceof BracedCommand) {
                BracedCommand.getBracedCommands(this);
            }
        }
    }

    public ScriptEntry addObject(String key, Object object) {
        if (object == null) {
            return this;
        }
        if (object instanceof dObject) {
            ((dObject)object).setPrefix(key);
        }
        this.objects.put(CoreUtilities.toLowerCase(key), object);
        return this;
    }

    public ScriptEntry defaultObject(String key, Object ... objects) throws InvalidArgumentsException {
        if (!this.objects.containsKey(CoreUtilities.toLowerCase(key))) {
            for (Object obj : objects) {
                if (obj == null) continue;
                this.addObject(key, obj);
                break;
            }
        }
        if (!this.hasObject(key)) {
            throw new InvalidArgumentsException("Missing '" + key + "' argument!");
        }
        return this;
    }

    public List<String> getArguments() {
        return this.args;
    }

    public List<String> getOriginalArguments() {
        return this.internal.pre_tagged_args;
    }

    public String getCommandName() {
        return this.internal.command;
    }

    public AbstractCommand getCommand() {
        return this.internal.actualCommand;
    }

    public void setArgument(int ind, String val) {
        this.args.set(ind, val);
        if (this.processed_arguments != null) {
            this.processed_arguments.set(ind, new Element(val));
        }
    }

    public ScriptEntry setArguments(List<String> arguments) {
        this.args = arguments;
        return this;
    }

    public ScriptEntry setArgumentsObjects(List<dObject> arguments) {
        this.processed_arguments = arguments;
        this.args = new ArrayList<String>(arguments.size());
        for (dObject tmp : arguments) {
            this.args.add(TagManager.escapeOutput(tmp.toString()));
        }
        return this;
    }

    public void objectify() {
        this.processed_arguments = new ArrayList<dObject>(this.args.size());
        for (String arg : this.args) {
            this.processed_arguments.add(new Element(arg));
        }
    }

    public void setOwner(ScriptEntry owner) {
        this.owner = owner;
    }

    public ScriptEntry getOwner() {
        return this.owner;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object result) {
        this.data = result;
    }

    public void copyFrom(ScriptEntry entry) {
        this.entryData = entry.entryData.clone();
        this.setSendingQueue(entry.getResidingQueue());
    }

    public Map<String, Object> getObjects() {
        return this.objects;
    }

    public Object getObject(String key) {
        try {
            return this.objects.get(key);
        }
        catch (Exception ex) {
            if (dB.verbose) {
                dB.echoError(ex);
            }
            return null;
        }
    }

    public <T extends dObject> T getdObject(String key) {
        try {
            Object gotten = this.objects.get(key);
            if (gotten instanceof Enum) {
                return (T)new Element(((Enum)gotten).name());
            }
            return (T)((dObject)gotten);
        }
        catch (Exception ex) {
            if (dB.verbose) {
                dB.echoError(ex);
            }
            return null;
        }
    }

    public Element getElement(String key) {
        try {
            return (Element)this.objects.get(key);
        }
        catch (Exception ex) {
            if (dB.verbose) {
                dB.echoError(ex);
            }
            return null;
        }
    }

    public boolean hasObject(String key) {
        return this.objects.containsKey(key);
    }

    public dScript getScript() {
        return this.internal.script;
    }

    public ScriptEntry setScript(String scriptName) {
        this.internal.script = dScript.valueOf(scriptName);
        return this;
    }

    public ScriptQueue getResidingQueue() {
        return this.queue;
    }

    public void setSendingQueue(ScriptQueue scriptQueue) {
        this.queue = scriptQueue;
    }

    public boolean isInstant() {
        return this.internal.instant || this.forceInstant;
    }

    public ScriptEntry setInstant(boolean instant) {
        this.forceInstant = instant;
        return this;
    }

    public boolean shouldWaitFor() {
        return this.internal.waitfor && !this.isFinished;
    }

    public ScriptEntry setFinished(boolean finished) {
        this.isFinished = finished;
        return this;
    }

    public ScriptEntry trackObject(String key) {
        this.tracked_objects.add(CoreUtilities.toLowerCase(key));
        return this;
    }

    public boolean dbCallShouldDebug() {
        return DenizenCore.getImplementation().shouldDebug(this);
    }

    @Override
    public boolean shouldDebug() {
        if (this.shouldDebugBool != null) {
            return this.shouldDebugBool;
        }
        if (this.internal.script == null || this.internal.script.getContainer() == null) {
            this.shouldDebugBool = this.fallbackDebug;
            return this.shouldDebugBool;
        }
        this.shouldDebugBool = this.internal.script.getContainer().shouldDebug();
        return this.shouldDebugBool;
    }

    @Override
    public boolean shouldFilter(String criteria) throws Exception {
        return this.internal.script.getName().equalsIgnoreCase(criteria.replace("s@", ""));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String str : this.getOriginalArguments()) {
            sb.append(" \"").append(str).append("\"");
        }
        for (aH.Argument arg : this.internal.preprocArgs) {
            sb.append(" \"").append(arg.toString()).append("\"");
        }
        return this.internal.command + sb.toString();
    }

    public static class Argument {
        public Argument prefix = null;
        public List<TagManager.ParseableTagPiece> value = null;
        public aH.Argument aHArg = null;
    }

    public static class ScriptEntryInternal {
        public String command = null;
        public AbstractCommand actualCommand = null;
        public List<String> pre_tagged_args = null;
        public List<BracedCommand.BracedData> bracedSet = null;
        public List<Argument> args_ref = null;
        public dScript script = null;
        public List<Object> insideList = null;
        public boolean instant = false;
        public boolean waitfor = false;
        public boolean hasTags = false;
        public boolean hasInstantTags = false;
        public boolean hasOldDefs = false;
        public int[] processArgs = null;
        public List<aH.Argument> preprocArgs = null;
        public Object specialProcessedData = null;
    }
}

