/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_18.helpers;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.CustomEntityHelper;
import com.denizenscript.denizen.nms.interfaces.FakeArrow;
import com.denizenscript.denizen.nms.interfaces.FakePlayer;
import com.denizenscript.denizen.nms.interfaces.ItemProjectile;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.v1_18.impl.entities.CraftFakePlayerImpl;
import com.denizenscript.denizen.nms.v1_18.impl.entities.EntityFakeArrowImpl;
import com.denizenscript.denizen.nms.v1_18.impl.entities.EntityFakePlayerImpl;
import com.denizenscript.denizen.nms.v1_18.impl.entities.EntityItemProjectileImpl;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.UUID;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.World;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class CustomEntityHelperImpl
implements CustomEntityHelper {
    public FakeArrow spawnFakeArrow(Location location) {
        CraftWorld world = (CraftWorld)location.getWorld();
        EntityFakeArrowImpl arrow = new EntityFakeArrowImpl(world, location);
        return arrow.getBukkitEntity();
    }

    public ItemProjectile spawnItemProjectile(Location location, ItemStack itemStack) {
        CraftWorld world = (CraftWorld)location.getWorld();
        EntityItemProjectileImpl entity = new EntityItemProjectileImpl((World)world.getHandle(), location, CraftItemStack.asNMSCopy((ItemStack)itemStack));
        world.getHandle().addFreshEntity((awt)entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return entity.getBukkitEntity();
    }

    public FakePlayer spawnFakePlayer(Location location, String name, String skin) throws IllegalArgumentException {
        return CustomEntityHelperImpl.spawnFakePlayer(location, name, skin, true);
    }

    public static FakePlayer spawnFakePlayer(Location location, String name, String skin, boolean doAdd) throws IllegalArgumentException {
        UUID uuid;
        String fullName = name;
        String prefix = null;
        String suffix = null;
        if (name == null) {
            return null;
        }
        if (fullName.length() > 16) {
            prefix = fullName.substring(0, 16);
            if (fullName.length() > 30) {
                int len = 30;
                name = fullName.substring(16, 30);
                if (name.matches(".*[^A-Za-z0-9_].*")) {
                    if (fullName.length() >= 32) {
                        len = 32;
                        name = fullName.substring(16, 32);
                    } else if (fullName.length() == 31) {
                        len = 31;
                        name = fullName.substring(16, 31);
                    }
                } else {
                    if (name.length() > 46) {
                        throw new IllegalArgumentException("You must specify a name with no more than 46 characters for FAKE_PLAYER entities!");
                    }
                    name = ChatColor.RESET + name;
                }
                suffix = fullName.substring(len);
            } else {
                name = fullName.substring(16);
                if (!name.matches(".*[^A-Za-z0-9_].*")) {
                    name = ChatColor.RESET + name;
                }
                if (name.length() > 16) {
                    suffix = name.substring(16);
                    name = name.substring(0, 16);
                }
            }
        }
        if (skin != null && skin.length() > 16) {
            throw new IllegalArgumentException("You must specify a name with no more than 16 characters for FAKE_PLAYER entity skins!");
        }
        CraftWorld world = (CraftWorld)location.getWorld();
        WorldServer worldServer = world.getHandle();
        PlayerProfile playerProfile = new PlayerProfile(name, null);
        if (skin == null && !name.matches(".*[^A-Za-z0-9_].*")) {
            playerProfile = NMSHandler.getInstance().fillPlayerProfile(playerProfile);
        }
        if (skin != null) {
            PlayerProfile skinProfile = new PlayerProfile(skin, null);
            skinProfile = NMSHandler.getInstance().fillPlayerProfile(skinProfile);
            playerProfile.setTexture(skinProfile.getTexture());
            playerProfile.setTextureSignature(skinProfile.getTextureSignature());
        }
        if ((uuid = UUID.randomUUID()).version() == 4) {
            long msb = uuid.getMostSignificantBits();
            msb &= 0xFFFFFFFFFFFFBFFFL;
            uuid = new UUID(msb |= 0x2000L, uuid.getLeastSignificantBits());
        }
        playerProfile.setUniqueId(uuid);
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        EntityFakePlayerImpl fakePlayer = new EntityFakePlayerImpl(worldServer.n(), worldServer, gameProfile, doAdd);
        fakePlayer.forceSetPositionRotation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        CraftFakePlayerImpl craftFakePlayer = fakePlayer.getBukkitEntity();
        craftFakePlayer.fullName = fullName;
        if (prefix != null) {
            Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
            String teamName = "FAKE_PLAYER_TEAM_" + fullName;
            String hash = null;
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] bytes = teamName.getBytes(StandardCharsets.UTF_8);
                md.update(bytes, 0, bytes.length);
                hash = new BigInteger(1, md.digest()).toString(16).substring(0, 16);
            }
            catch (Exception e) {
                Debug.echoError((Throwable)e);
            }
            if (hash != null) {
                Team team = scoreboard.getTeam(hash);
                if (team == null) {
                    team = scoreboard.registerNewTeam(hash);
                    team.setPrefix(prefix);
                    if (suffix != null) {
                        team.setSuffix(suffix);
                    }
                }
                team.addPlayer((OfflinePlayer)craftFakePlayer);
            }
        }
        return craftFakePlayer;
    }
}

