/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_17.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.chunk.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    public BiomeBase biomeBase;
    public WorldServer world;

    public BiomeNMSImpl(WorldServer world, String name) {
        super((World)world.getWorld(), name);
        this.world = world;
        this.biomeBase = (BiomeBase)world.t().d(IRegistry.aO).get(new MinecraftKey(name));
    }

    public BiomeNMS.DownfallType getDownfallType() {
        BiomeBase.Precipitation nmsType = this.biomeBase.c();
        switch (nmsType) {
            case b: {
                return BiomeNMS.DownfallType.RAIN;
            }
            case c: {
                return BiomeNMS.DownfallType.SNOW;
            }
            case a: {
                return BiomeNMS.DownfallType.NONE;
            }
        }
        throw new UnsupportedOperationException();
    }

    public float getHumidity() {
        return this.biomeBase.getHumidity();
    }

    public float getTemperature() {
        return this.biomeBase.k();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(EnumCreatureType.c);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(EnumCreatureType.b);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.a);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.e);
    }

    public Object getClimate() {
        return ReflectionHelper.getFieldValue(BiomeBase.class, (String)ReflectionMappingsInfo.Biome_climateSettings, (Object)this.biomeBase);
    }

    public void setHumidity(float humidity) {
        Object climate = this.getClimate();
        ReflectionHelper.setFieldValue(climate.getClass(), (String)ReflectionMappingsInfo.Biome_ClimateSettings_downfall, (Object)climate, (Object)Float.valueOf(humidity));
    }

    public void setTemperature(float temperature) {
        Object climate = this.getClimate();
        ReflectionHelper.setFieldValue(climate.getClass(), (String)ReflectionMappingsInfo.Biome_ClimateSettings_temperature, (Object)climate, (Object)Float.valueOf(temperature));
    }

    public void setPrecipitation(BiomeNMS.DownfallType type) {
        BiomeBase.Precipitation nmsType;
        switch (type) {
            case NONE: {
                nmsType = BiomeBase.Precipitation.a;
                break;
            }
            case RAIN: {
                nmsType = BiomeBase.Precipitation.b;
                break;
            }
            case SNOW: {
                nmsType = BiomeBase.Precipitation.c;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        Object climate = this.getClimate();
        ReflectionHelper.setFieldValue(climate.getClass(), (String)ReflectionMappingsInfo.Biome_ClimateSettings_precipitation, (Object)climate, (Object)nmsType);
    }

    private List<EntityType> getSpawnableEntities(EnumCreatureType creatureType) {
        BiomeSettingsMobs mobs = this.biomeBase.b();
        WeightedRandomList typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (BiomeSettingsMobs.c meta : typeSettingList.d()) {
            try {
                String n = EntityTypes.getName((EntityTypes)meta.b).getKey();
                EntityType et = EntityType.fromName((String)n);
                if (et == null) {
                    et = EntityType.valueOf((String)n.toUpperCase(Locale.ENGLISH));
                }
                entityTypes.add(et);
            }
            catch (Throwable throwable) {}
        }
        return entityTypes;
    }

    public void setTo(Block block) {
        Chunk chunk;
        if (((CraftWorld)block.getWorld()).getHandle() != this.world) {
            NMSHandler.getInstance().getBiomeNMS(block.getWorld(), this.getName()).setTo(block);
            return;
        }
        BlockPosition pos = new BlockPosition(block.getX(), 0, block.getZ());
        if (this.world.isLoaded(pos) && (chunk = this.world.getChunkAtWorldCoords(pos)) != null) {
            chunk.getBiomeIndex().setBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2, this.biomeBase);
            chunk.markDirty();
        }
    }
}

