/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import java.util.Arrays;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class PlayerClicksBlockScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerClicksBlockScriptEvent instance = this;
    public PlayerInteractEvent event;
    public ItemTag item;
    public LocationTag location;
    public ElementTag click_type;
    public ElementTag hand;
    public MaterialTag blockMaterial;
    private static final HashSet<String> matchHelpList = new HashSet<String>(Arrays.asList("at", "entity", "npc", "player", "vehicle", "projectile", "hanging", "fake"));
    private static final HashSet<String> withHelpList = new HashSet<String>(Arrays.asList("with", "using", "in"));
    public boolean wasCancellationAltered;

    public PlayerClicksBlockScriptEvent() {
        this.registerCouldMatcher("player (right|left) clicks <block>");
        this.registerSwitches("with", "using", "type");
    }

    private boolean runUsingCheck(ScriptEvent.ScriptPath path) {
        String using = path.switches.get("using");
        if (using == null) {
            int index;
            for (index = 0; index < path.eventArgsLower.length && !path.eventArgsLower[index].equals("using"); ++index) {
            }
            using = index >= path.eventArgsLower.length ? "hand" : path.eventArgLowerAt(index + 1);
        }
        if (!(using.equals("hand") || using.equals("off_hand") || using.equals("either_hand"))) {
            Debug.echoError("Invalid USING hand in " + this.getName() + " for '" + path.event + "' in " + path.container.getName());
            return false;
        }
        return using.equals("either_hand") || PlayerClicksBlockScriptEvent.runGenericCheck(using, this.hand.identify());
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        boolean clickFirst = path.eventArgLowerAt(1).equals("clicks");
        if (!clickFirst && !path.eventArgLowerAt(2).equals("clicks")) {
            return false;
        }
        if (!(clickFirst || path.eventArgLowerAt(1).equals("right") || path.eventArgLowerAt(1).equals("left"))) {
            return false;
        }
        String clickedOn = path.eventArgLowerAt(clickFirst ? 2 : 3);
        if (matchHelpList.contains(clickedOn)) {
            return false;
        }
        if (!(clickedOn.isEmpty() || PlayerClicksBlockScriptEvent.couldMatchBlock(clickedOn) || clickedOn.equals("with") || clickedOn.equals("in") || clickedOn.equals("using"))) {
            return false;
        }
        if (!PlayerClicksBlockScriptEvent.couldMatchLegacyInArea(path.eventLower)) {
            return false;
        }
        if (clickedOn.isEmpty()) {
            Debug.echoError("'on player clicks:' is is not valid, use 'on player clicks block:' (for script '" + path.container.getName() + "').");
        }
        return true;
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        int index;
        int n = index = path.eventArgLowerAt(1).equals("clicks") ? 1 : 2;
        if (index == 2 && !this.click_type.identify().startsWith(path.eventArgLowerAt(1).toUpperCase())) {
            return false;
        }
        String mat = path.eventArgLowerAt(index + 1);
        if (mat.length() > 0 && !withHelpList.contains(mat) && !PlayerClicksBlockScriptEvent.tryMaterial(this.blockMaterial, mat)) {
            return false;
        }
        if (!PlayerClicksBlockScriptEvent.nonSwitchWithCheck(path, new ItemTag(this.event.getItem()))) {
            return false;
        }
        if (!PlayerClicksBlockScriptEvent.runWithCheck(path, new ItemTag(this.event.getItem()))) {
            return false;
        }
        if (!this.runUsingCheck(path)) {
            return false;
        }
        if (!this.runInCheck(path, this.location != null ? this.location : this.event.getPlayer().getLocation())) {
            return false;
        }
        if (path.switches.containsKey("type") && !PlayerClicksBlockScriptEvent.tryMaterial(this.blockMaterial, path.switches.get("type"))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerClicksBlock";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        this.wasCancellationAltered = true;
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(EntityTag.getPlayerFrom((Entity)this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "item": {
                return this.item;
            }
            case "location": {
                return this.location;
            }
            case "click_type": {
                return this.click_type;
            }
            case "hand": {
                return this.hand;
            }
            case "relative": {
                return this.event.hasBlock() ? new LocationTag(this.event.getClickedBlock().getRelative(this.event.getBlockFace()).getLocation()) : null;
            }
        }
        return super.getContext(name);
    }

    @Override
    public void cancellationChanged() {
        this.event.setCancelled(this.cancelled);
    }

    @EventHandler
    public void playerClicksBlock(PlayerInteractEvent event) {
        if (event.getAction() == Action.PHYSICAL) {
            return;
        }
        this.blockMaterial = event.hasBlock() ? new MaterialTag(event.getClickedBlock()) : new MaterialTag(Material.AIR);
        this.hand = new ElementTag(event.getHand().name());
        this.item = new ItemTag(event.getItem());
        this.location = event.hasBlock() ? new LocationTag(event.getClickedBlock().getLocation()) : null;
        this.click_type = new ElementTag(event.getAction().name());
        this.cancelled = event.isCancelled() && event.useItemInHand() == Event.Result.DENY;
        this.event = event;
        this.fire();
    }
}

