/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.npc.traits.InvisibleTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;

public class EntityVisible
implements Property {
    public static final String[] handledTags = new String[]{"visible"};
    public static final String[] handledMechs = new String[]{"visible"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && (((EntityTag)entity).getBukkitEntity() instanceof ArmorStand || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_16) && ((EntityTag)entity).getBukkitEntity() instanceof ItemFrame);
    }

    public static EntityVisible getFrom(ObjectTag entity) {
        if (!EntityVisible.describes(entity)) {
            return null;
        }
        return new EntityVisible((EntityTag)entity);
    }

    private EntityVisible(EntityTag ent) {
        this.entity = ent;
    }

    public boolean isVisible() {
        if (this.entity.getBukkitEntity() instanceof ArmorStand) {
            return ((ArmorStand)this.entity.getBukkitEntity()).isVisible();
        }
        return ((ItemFrame)this.entity.getBukkitEntity()).isVisible();
    }

    @Override
    public String getPropertyString() {
        if (!this.isVisible()) {
            return "false";
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "visible";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("visible")) {
            return new ElementTag(this.isVisible()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("visible") && mechanism.requireBoolean()) {
            if (Depends.citizens != null && this.entity.isLivingEntity() && CitizensAPI.getNPCRegistry().isNPC((Entity)this.entity.getLivingEntity())) {
                InvisibleTrait.setInvisible(this.entity.getLivingEntity(), CitizensAPI.getNPCRegistry().getNPC(this.entity.getBukkitEntity()), !mechanism.getValue().asBoolean());
            } else if (this.entity.getBukkitEntity() instanceof ArmorStand) {
                ((ArmorStand)this.entity.getBukkitEntity()).setVisible(mechanism.getValue().asBoolean());
            } else {
                ((ItemFrame)this.entity.getBukkitEntity()).setVisible(mechanism.getValue().asBoolean());
            }
        }
    }
}

