/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.MultiVersionHelper1_17;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Campfire;
import org.bukkit.block.data.type.PointedDripstone;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.TechnicalPiston;

public class MaterialBlockType
implements Property {
    public static final String[] handledMechs = new String[]{"type", "slab_type"};
    public MaterialTag material;

    public static boolean describes(ObjectTag material) {
        if (!(material instanceof MaterialTag)) {
            return false;
        }
        MaterialTag mat = (MaterialTag)material;
        if (!mat.hasModernData()) {
            return false;
        }
        BlockData data = mat.getModernData();
        return data instanceof Slab || data instanceof TechnicalPiston || data instanceof Campfire || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && data instanceof PointedDripstone;
    }

    public static MaterialBlockType getFrom(ObjectTag _material) {
        if (!MaterialBlockType.describes(_material)) {
            return null;
        }
        return new MaterialBlockType((MaterialTag)_material);
    }

    private MaterialBlockType(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerStaticTag(ElementTag.class, "type", (attribute, material) -> new ElementTag(material.getPropertyString()), "slab_type");
    }

    public boolean isSlab() {
        return this.material.getModernData() instanceof Slab;
    }

    public boolean isPistonHead() {
        return this.material.getModernData() instanceof TechnicalPiston;
    }

    public boolean isCampfire() {
        return this.material.getModernData() instanceof Campfire;
    }

    public boolean isDripstone() {
        return NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && this.material.getModernData() instanceof PointedDripstone;
    }

    public Slab getSlab() {
        return (Slab)this.material.getModernData();
    }

    public TechnicalPiston getPistonHead() {
        return (TechnicalPiston)this.material.getModernData();
    }

    public Campfire getCampfire() {
        return (Campfire)this.material.getModernData();
    }

    @Override
    public String getPropertyString() {
        if (this.isSlab()) {
            return this.getSlab().getType().name();
        }
        if (this.isCampfire()) {
            return this.getCampfire().isSignalFire() ? "SIGNAL" : "NORMAL";
        }
        if (this.isPistonHead()) {
            return this.getPistonHead().getType().name();
        }
        if (this.isDripstone()) {
            return ((PointedDripstone)this.material.getModernData()).getThickness().name();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "type";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("type") || mechanism.matches("slab_type")) {
            if (this.isSlab() && mechanism.requireEnum(false, (Enum<?>[])Slab.Type.values())) {
                this.getSlab().setType(Slab.Type.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (this.isCampfire()) {
                this.getCampfire().setSignalFire(CoreUtilities.equalsIgnoreCase(mechanism.getValue().asString(), "signal"));
            } else if (this.isPistonHead() && mechanism.requireEnum(false, (Enum<?>[])TechnicalPiston.Type.values())) {
                this.getPistonHead().setType(TechnicalPiston.Type.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else {
                MultiVersionHelper1_17.materialBlockTypeRunMech(mechanism, this);
            }
        }
    }
}

