/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.nbt.CustomNBT;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import org.bukkit.inventory.ItemStack;

public class NBTCommand
extends AbstractCommand {
    public NBTCommand() {
        this.setName("nbt");
        this.setSyntax("(Deprecated)");
        this.setRequiredArguments(0, -1);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("key") && arg.getRawValue().split(":", 2).length == 2) {
                String[] flagArgs = arg.getRawValue().split(":", 2);
                scriptEntry.addObject("key", new ElementTag(flagArgs[0]));
                scriptEntry.addObject("value", new ElementTag(flagArgs[1]));
                continue;
            }
            if (!scriptEntry.hasObject("item") && arg.matchesArgumentType(ItemTag.class)) {
                scriptEntry.addObject("item", arg.asType(ItemTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("item")) {
            throw new InvalidArgumentsException("Must specify item!");
        }
        if (!scriptEntry.hasObject("key") || !scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify key and value!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Deprecations.nbtCommand.warn(scriptEntry);
        ItemTag item = (ItemTag)scriptEntry.getObjectTag("item");
        ElementTag key = scriptEntry.getElement("key");
        ElementTag value = scriptEntry.getElement("value");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), item, key, value);
        }
        ItemStack itemStack = item.getItemStack();
        itemStack = value.asString().equals("!") ? CustomNBT.removeCustomNBT(itemStack, key.asString(), "Denizen NBT") : CustomNBT.addCustomNBT(itemStack, key.asString(), value.asString(), "Denizen NBT");
        scriptEntry.addObject("new_item", new ItemTag(itemStack));
    }
}

