/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class PlayerEquipsArmorScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static HashMap<String, PlayerArmorChangeEvent.SlotType> slotsByName = new HashMap();
    public static HashMap<PlayerArmorChangeEvent.SlotType, String> namesBySlot = new HashMap();
    public static PlayerEquipsArmorScriptEvent instance;
    public ItemTag oldItem;
    public ItemTag newItem;
    public PlayerArmorChangeEvent.SlotType slot;
    public PlayerTag player;

    public static void registerSlot(String name, PlayerArmorChangeEvent.SlotType slot) {
        slotsByName.put(name, slot);
        namesBySlot.put(slot, name);
    }

    public PlayerEquipsArmorScriptEvent() {
        instance = this;
        PlayerEquipsArmorScriptEvent.registerSlot("helmet", PlayerArmorChangeEvent.SlotType.HEAD);
        PlayerEquipsArmorScriptEvent.registerSlot("chestplate", PlayerArmorChangeEvent.SlotType.CHEST);
        PlayerEquipsArmorScriptEvent.registerSlot("leggings", PlayerArmorChangeEvent.SlotType.LEGS);
        PlayerEquipsArmorScriptEvent.registerSlot("boots", PlayerArmorChangeEvent.SlotType.FEET);
        this.registerCouldMatcher("player (equips|unequips) armor|helmet|chestplate|leggings|boots");
        this.registerCouldMatcher("player (equips|unequips) <item>");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        String type = path.eventArgLowerAt(1);
        String itemCompare = path.eventArgLowerAt(2);
        PlayerArmorChangeEvent.SlotType slotType = slotsByName.get(itemCompare);
        if (slotType != null && this.slot != slotType) {
            return false;
        }
        if (type.equals("equips") ? (slotType != null ? this.newItem.getMaterial().getMaterial() == Material.AIR : !itemCompare.equals("armor") && !PlayerEquipsArmorScriptEvent.tryItem((ItemTag)this.newItem, (String)itemCompare)) : (slotType != null ? this.oldItem.getMaterial().getMaterial() == Material.AIR : !itemCompare.equals("armor") && !PlayerEquipsArmorScriptEvent.tryItem((ItemTag)this.oldItem, (String)itemCompare))) {
            return false;
        }
        return super.matches(path);
    }

    public String getName() {
        return "PlayerEquipsArmor";
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "new_item": {
                return this.newItem;
            }
            case "old_item": {
                return this.oldItem;
            }
            case "slot": {
                return new ElementTag(namesBySlot.get(this.slot));
            }
        }
        return super.getContext(name);
    }

    public String simpleComparisonString(ItemStack stack) {
        if (stack == null) {
            return "null";
        }
        stack = stack.clone();
        stack.setAmount(1);
        stack.setDurability((short)0);
        return CoreUtilities.toLowerCase((String)new ItemTag(stack).identify());
    }

    @EventHandler
    public void armorChangeEvent(PlayerArmorChangeEvent event) {
        if (EntityTag.isCitizensNPC((Entity)event.getPlayer())) {
            return;
        }
        if (this.simpleComparisonString(event.getOldItem()).equals(this.simpleComparisonString(event.getNewItem()))) {
            return;
        }
        this.newItem = new ItemTag(event.getNewItem());
        this.oldItem = new ItemTag(event.getOldItem());
        this.slot = event.getSlotType();
        this.player = new PlayerTag(event.getPlayer());
        this.fire((Event)event);
    }
}

