/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities.data;

import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.data.ActionableDataProvider;
import com.denizenscript.denizencore.utilities.data.DataActionException;
import com.denizenscript.denizencore.utilities.data.DataActionType;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class DataAction {
    public ActionableDataProvider provider;
    public DataActionType type;
    public String key;
    public int index = 0;
    public ObjectTag inputValue = null;

    public String toString() {
        String keyDebug = this.key;
        if (this.index != 0) {
            keyDebug = keyDebug + (this.index == Integer.MAX_VALUE ? "[last]" : "[" + this.index + "]");
        }
        return "(" + keyDebug + ":" + (Object)((Object)this.type) + ":" + this.inputValue + ")";
    }

    public ListTag autoList(String key, TagContext context) {
        ObjectTag obj = this.provider.getValueAt(key);
        if (obj == null) {
            return new ListTag();
        }
        return this.autoList(ListTag.getListFor(obj, context));
    }

    public ListTag autoList(ListTag list) {
        return new ListTag(list);
    }

    public ObjectTag autoDup(ObjectTag object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ListTag) {
            return this.autoList((ListTag)object);
        }
        return object.duplicate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BigDecimal autoNumber(TagContext context) {
        ObjectTag obj = this.provider.getValueAt(this.key);
        if (this.index != 0) {
            ListTag subList = ListTag.getListFor(obj, context);
            if (this.index < 0 || this.index > subList.size()) {
                if (this.index != Integer.MAX_VALUE || subList.isEmpty()) return BigDecimal.ZERO;
                obj = subList.getObject(subList.size() - 1);
            } else {
                obj = subList.getObject(this.index - 1);
            }
        }
        try {
            return this.autoNumber(obj);
        }
        catch (NumberFormatException ex) {
            return BigDecimal.ZERO;
        }
    }

    public BigDecimal autoNumber(ObjectTag obj) {
        if (obj == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(obj.toString());
    }

    public ElementTag autoNumber(BigDecimal decimal) {
        return new ElementTag(decimal);
    }

    public void autoSet(ObjectTag value, TagContext context) {
        if (this.index != 0) {
            ObjectTag obj = this.provider.getValueAt(this.key);
            ListTag subList = ListTag.getListFor(obj, context);
            if (this.index == Integer.MAX_VALUE) {
                subList.setObject(subList.isEmpty() ? 0 : subList.size() - 1, value);
            } else {
                subList.setObject(this.index - 1, value);
            }
            value = subList;
        }
        this.provider.setValueAt(this.key, value);
    }

    public void requiresInputValue() {
        if (this.inputValue == null) {
            throw new DataActionException("Input value required for data action " + (Object)((Object)this.type) + ".");
        }
    }

    public void execute(TagContext context) {
        switch (this.type) {
            case INCREMENT: {
                BigDecimal num = this.autoNumber(context);
                num = num.add(BigDecimal.ONE);
                this.autoSet(this.autoNumber(num), context);
                break;
            }
            case DECREMENT: {
                BigDecimal num = this.autoNumber(context);
                num = num.subtract(BigDecimal.ONE);
                this.autoSet(this.autoNumber(num), context);
                break;
            }
            case ADD: {
                this.requiresInputValue();
                BigDecimal num = this.autoNumber(context);
                num = num.add(this.autoNumber(this.inputValue));
                this.autoSet(this.autoNumber(num), context);
                break;
            }
            case SUBTRACT: {
                this.requiresInputValue();
                BigDecimal num = this.autoNumber(context);
                num = num.subtract(this.autoNumber(this.inputValue));
                this.autoSet(this.autoNumber(num), context);
                break;
            }
            case MULTIPLY: {
                this.requiresInputValue();
                BigDecimal num = this.autoNumber(context);
                num = num.multiply(this.autoNumber(this.inputValue));
                this.autoSet(this.autoNumber(num), context);
                break;
            }
            case DIVIDE: {
                this.requiresInputValue();
                BigDecimal num = this.autoNumber(context);
                num = num.setScale(15, RoundingMode.HALF_UP);
                num = num.divide(this.autoNumber(this.inputValue), RoundingMode.HALF_UP);
                this.autoSet(this.autoNumber(num), context);
                break;
            }
            case INSERT: {
                this.requiresInputValue();
                ListTag list = this.autoList(this.key, context);
                list.addObject(this.inputValue);
                this.provider.setValueAt(this.key, list);
                break;
            }
            case REMOVE: {
                ListTag list = this.autoList(this.key, context);
                if (this.index != 0) {
                    if (this.index == Integer.MAX_VALUE && !list.isEmpty()) {
                        list.remove(list.size() - 1);
                    } else {
                        list.remove(this.index - 1);
                    }
                } else {
                    this.requiresInputValue();
                    String findValue = this.inputValue.toString();
                    for (int i = 0; i < list.size(); ++i) {
                        if (!CoreUtilities.equalsIgnoreCase(list.get(i), findValue)) continue;
                        list.remove(i);
                        break;
                    }
                }
                this.provider.setValueAt(this.key, list);
                break;
            }
            case SPLIT: {
                this.requiresInputValue();
                ListTag list = this.autoList(this.key, context);
                list.addObjects(ListTag.getListFor((ObjectTag)this.inputValue, (TagContext)context).objectForms);
                this.provider.setValueAt(this.key, list);
                break;
            }
            case SPLIT_NEW: {
                Deprecations.splitNewDataAction.warn(context);
                this.requiresInputValue();
                this.provider.setValueAt(this.key, this.autoList(ListTag.getListFor(this.inputValue, context)));
                break;
            }
            case SET: {
                this.requiresInputValue();
                this.autoSet(this.autoDup(this.inputValue), context);
                break;
            }
            case AUTO_SET: {
                this.provider.setValueAt(this.key, new ElementTag(true));
                break;
            }
            case CLEAR: {
                this.provider.setValueAt(this.key, null);
            }
        }
    }
}

