/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.RedstoneWire;
import org.bukkit.block.data.type.Wall;

public class MaterialSides
implements Property {
    public static final String[] handledMechs = new String[]{"sides", "heights"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        if (!(material instanceof MaterialTag)) {
            return false;
        }
        MaterialTag mat = (MaterialTag)material;
        if (!mat.hasModernData()) {
            return false;
        }
        BlockData data = mat.getModernData();
        return data instanceof Wall || data instanceof RedstoneWire;
    }

    public static MaterialSides getFrom(ObjectTag _material) {
        if (!MaterialSides.describes(_material)) {
            return null;
        }
        return new MaterialSides((MaterialTag)_material);
    }

    private MaterialSides(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerStaticTag(ListTag.class, "sides", (attribute, material) -> material.getSidesList(), "heights");
    }

    public boolean isWall() {
        return this.material.getModernData() instanceof Wall;
    }

    public Wall getWall() {
        return (Wall)this.material.getModernData();
    }

    public boolean isWire() {
        return this.material.getModernData() instanceof RedstoneWire;
    }

    public RedstoneWire getWire() {
        return (RedstoneWire)this.material.getModernData();
    }

    public ListTag getSidesList() {
        ListTag list = new ListTag(5);
        if (this.isWall()) {
            Wall wall = this.getWall();
            list.add(wall.getHeight(BlockFace.NORTH).name());
            list.add(wall.getHeight(BlockFace.EAST).name());
            list.add(wall.getHeight(BlockFace.SOUTH).name());
            list.add(wall.getHeight(BlockFace.WEST).name());
            list.add(wall.isUp() ? "TALL" : "NONE");
        } else if (this.isWire()) {
            RedstoneWire wire = this.getWire();
            list.add(wire.getFace(BlockFace.NORTH).name());
            list.add(wire.getFace(BlockFace.EAST).name());
            list.add(wire.getFace(BlockFace.SOUTH).name());
            list.add(wire.getFace(BlockFace.WEST).name());
        }
        return list;
    }

    @Override
    public String getPropertyString() {
        return this.getSidesList().identify();
    }

    @Override
    public String getPropertyId() {
        return "sides";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("sides") || mechanism.matches("heights")) && mechanism.requireObject(ListTag.class)) {
            ListTag list = mechanism.valueAsType(ListTag.class);
            if (this.isWall()) {
                if (list.size() != 5) {
                    mechanism.echoError("Invalid sides list, size must be 5.");
                    return;
                }
                Wall wall = this.getWall();
                wall.setHeight(BlockFace.NORTH, Wall.Height.valueOf((String)list.get(0).toUpperCase()));
                wall.setHeight(BlockFace.EAST, Wall.Height.valueOf((String)list.get(1).toUpperCase()));
                wall.setHeight(BlockFace.SOUTH, Wall.Height.valueOf((String)list.get(2).toUpperCase()));
                wall.setHeight(BlockFace.WEST, Wall.Height.valueOf((String)list.get(3).toUpperCase()));
                wall.setUp(list.get(4).toUpperCase().equals("TALL"));
            } else if (this.isWire()) {
                if (list.size() != 4) {
                    mechanism.echoError("Invalid sides list, size must be 4.");
                    return;
                }
                RedstoneWire wire = this.getWire();
                wire.setFace(BlockFace.NORTH, RedstoneWire.Connection.valueOf((String)list.get(0).toUpperCase()));
                wire.setFace(BlockFace.EAST, RedstoneWire.Connection.valueOf((String)list.get(1).toUpperCase()));
                wire.setFace(BlockFace.SOUTH, RedstoneWire.Connection.valueOf((String)list.get(2).toUpperCase()));
                wire.setFace(BlockFace.WEST, RedstoneWire.Connection.valueOf((String)list.get(3).toUpperCase()));
            }
        }
    }
}

