/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.TraitInfo;

public class TraitCommand
extends AbstractCommand {
    public TraitCommand() {
        this.setName("trait");
        this.setSyntax("trait (state:true/false/{toggle}) [<trait>] (to:<npc>|...)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        for (TraitInfo trait : CitizensAPI.getTraitFactory().getRegisteredTraits()) {
            tab.add(trait.getTraitName());
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("state") && arg.matchesPrefix("state", "s") && arg.matchesEnum(Toggle.values())) {
                scriptEntry.addObject("state", new ElementTag(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("trait")) {
                scriptEntry.addObject("trait", new ElementTag(arg.getValue()));
                continue;
            }
            if (!scriptEntry.hasObject("npcs") && arg.matchesArgumentList(NPCTag.class)) {
                scriptEntry.addObject("npcs", arg.asType(ListTag.class).filter(NPCTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("trait")) {
            throw new InvalidArgumentsException("Missing trait argument!");
        }
        if (!scriptEntry.hasObject("npcs")) {
            if (!Utilities.entryHasNPC(scriptEntry)) {
                throw new InvalidArgumentsException("This command requires a linked NPC!");
            }
            scriptEntry.addObject("npcs", Collections.singletonList(Utilities.getEntryNPC(scriptEntry)));
        }
        scriptEntry.defaultObject("state", new ElementTag("TOGGLE"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Class trait;
        ElementTag toggle = scriptEntry.getElement("state");
        ElementTag traitName = scriptEntry.getElement("trait");
        List npcs = (List)scriptEntry.getObject("npcs");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), traitName, toggle, TraitCommand.db("npc", npcs));
        }
        if ((trait = CitizensAPI.getTraitFactory().getTraitClass(traitName.asString())) == null) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Trait not found: " + traitName.asString());
            return;
        }
        for (NPCTag npcTag : npcs) {
            NPC npc = npcTag.getCitizen();
            switch (Toggle.valueOf(toggle.asString())) {
                case TRUE: 
                case ON: {
                    if (npc.hasTrait(trait)) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "NPC already has trait '" + traitName.asString() + "'");
                        break;
                    }
                    npc.addTrait(trait);
                    break;
                }
                case FALSE: 
                case OFF: {
                    if (!npc.hasTrait(trait)) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "NPC does not have trait '" + traitName.asString() + "'");
                        break;
                    }
                    npc.removeTrait(trait);
                    break;
                }
                case TOGGLE: {
                    if (npc.hasTrait(trait)) {
                        npc.removeTrait(trait);
                        break;
                    }
                    npc.addTrait(trait);
                }
            }
        }
    }

    private static enum Toggle {
        TOGGLE,
        TRUE,
        FALSE,
        ON,
        OFF;

    }
}

