/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Zombie;

public class EntityConversionTime
implements Property {
    public static final String[] handledMechs = new String[]{"conversion_duration", "drowned_conversion_duration"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof Zombie && !(((EntityTag)entity).getBukkitEntity() instanceof PigZombie);
    }

    public static EntityConversionTime getFrom(ObjectTag entity) {
        if (!EntityConversionTime.describes(entity)) {
            return null;
        }
        return new EntityConversionTime((EntityTag)entity);
    }

    private EntityConversionTime(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        if (this.getZombie().isConverting()) {
            return this.getConversionTime().identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "conversion_duration";
    }

    public static void registerTags() {
        PropertyParser.registerTag(DurationTag.class, "conversion_duration", (attribute, object) -> {
            if (!object.getZombie().isConverting()) {
                attribute.echoError("This entity is not converting!");
                return null;
            }
            return object.getConversionTime();
        }, "drowned_conversion_duration");
        PropertyParser.registerTag(ElementTag.class, "is_converting", (attribute, object) -> new ElementTag(object.getZombie().isConverting()), new String[0]);
    }

    public Zombie getZombie() {
        return (Zombie)this.entity.getBukkitEntity();
    }

    public DurationTag getConversionTime() {
        return new DurationTag((long)this.getZombie().getConversionTime());
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("conversion_duration") || mechanism.matches("drowned_conversion_duration")) && mechanism.requireObject(DurationTag.class)) {
            this.getZombie().setConversionTime(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
    }
}

