/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.List;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.trait.trait.Spawned;

public class DespawnCommand
extends AbstractCommand {
    public DespawnCommand() {
        this.setName("despawn");
        this.setSyntax("despawn (<npc>|...)");
        this.setRequiredArguments(0, 1);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("npcs") && arg.matchesArgumentList(NPCTag.class)) {
                scriptEntry.addObject("npcs", arg.asType(ListTag.class).filter(NPCTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("npcs")) {
            if (Utilities.entryHasNPC(scriptEntry)) {
                scriptEntry.addObject("npcs", Collections.singletonList(Utilities.getEntryNPC(scriptEntry)));
            } else {
                throw new InvalidArgumentsException("Must specify a valid list of NPCs!");
            }
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List npcs = (List)scriptEntry.getObject("npcs");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), DespawnCommand.db("NPCs", npcs));
        }
        for (NPCTag npc : npcs) {
            if (npc.getCitizen().hasTrait(Spawned.class)) {
                ((Spawned)npc.getCitizen().getOrAddTrait(Spawned.class)).setSpawned(false);
            }
            if (!npc.isSpawned()) continue;
            npc.getCitizen().despawn(DespawnReason.PLUGIN);
        }
    }
}

