/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.Map;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;

public class EntityAttributeBaseValues
implements Property {
    public static final String[] handledTags = new String[]{"has_attribute", "attribute_value", "attribute_base_value", "attribute_default_value"};
    public static final String[] handledMechs = new String[]{"attribute_base_values"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof Attributable;
    }

    public static EntityAttributeBaseValues getFrom(ObjectTag entity) {
        if (!EntityAttributeBaseValues.describes(entity)) {
            return null;
        }
        return new EntityAttributeBaseValues((EntityTag)entity);
    }

    private EntityAttributeBaseValues(EntityTag entity) {
        this.entity = entity;
    }

    public MapTag attributeBaseValues() {
        MapTag result = new MapTag();
        Attributable ent = (Attributable)this.entity.getBukkitEntity();
        for (Attribute attr : Attribute.values()) {
            AttributeInstance instance = ent.getAttribute(attr);
            if (instance == null) continue;
            result.putObject(attr.name(), new ElementTag(instance.getBaseValue()));
        }
        return result;
    }

    @Override
    public String getPropertyString() {
        MapTag map = this.attributeBaseValues();
        if (map.map.isEmpty()) {
            return null;
        }
        return map.savable();
    }

    @Override
    public String getPropertyId() {
        return "attribute_base_values";
    }

    @Override
    public ObjectTag getObjectAttribute(com.denizenscript.denizencore.tags.Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("has_attribute") && attribute.hasParam()) {
            AttributeInstance instance = ((Attributable)this.entity.getBukkitEntity()).getAttribute(Attribute.valueOf((String)attribute.getParam().toUpperCase()));
            return new ElementTag(instance != null).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("attribute_value") && attribute.hasParam()) {
            Attribute attr = Attribute.valueOf((String)attribute.getParam().toUpperCase());
            AttributeInstance instance = ((Attributable)this.entity.getBukkitEntity()).getAttribute(attr);
            if (instance == null) {
                attribute.echoError("Attribute " + attr.name() + " is not applicable to entity of type " + this.entity.getBukkitEntity().getType().name());
                return null;
            }
            return new ElementTag(instance.getValue()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("attribute_base_value") && attribute.hasParam()) {
            Attribute attr = Attribute.valueOf((String)attribute.getParam().toUpperCase());
            AttributeInstance instance = ((Attributable)this.entity.getBukkitEntity()).getAttribute(attr);
            if (instance == null) {
                attribute.echoError("Attribute " + attr.name() + " is not applicable to entity of type " + this.entity.getBukkitEntity().getType().name());
                return null;
            }
            return new ElementTag(instance.getBaseValue()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("attribute_default_value") && attribute.hasParam()) {
            Attribute attr = Attribute.valueOf((String)attribute.getParam().toUpperCase());
            AttributeInstance instance = ((Attributable)this.entity.getBukkitEntity()).getAttribute(attr);
            if (instance == null) {
                attribute.echoError("Attribute " + attr.name() + " is not applicable to entity of type " + this.entity.getBukkitEntity().getType().name());
                return null;
            }
            return new ElementTag(instance.getDefaultValue()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("attribute_base_values") && mechanism.requireObject(MapTag.class)) {
            MapTag input = mechanism.valueAsType(MapTag.class);
            Attributable ent = (Attributable)this.entity.getBukkitEntity();
            for (Map.Entry<StringHolder, ObjectTag> subValue : input.map.entrySet()) {
                Attribute attr = Attribute.valueOf((String)subValue.getKey().str.toUpperCase());
                AttributeInstance instance = ent.getAttribute(attr);
                if (instance == null) {
                    mechanism.echoError("Attribute " + attr.name() + " is not applicable to entity of type " + this.entity.getBukkitEntity().getType().name());
                    continue;
                }
                instance.setBaseValue(Double.parseDouble(subValue.getValue().toString()));
            }
        }
    }
}

