/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_15.helpers;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.PacketHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.JNBTListTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_15.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.nms.v1_15.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.v1_15_R1.Block;
import net.minecraft.server.v1_15_R1.BlockPosition;
import net.minecraft.server.v1_15_R1.ChatComponentText;
import net.minecraft.server.v1_15_R1.DataWatcher;
import net.minecraft.server.v1_15_R1.DataWatcherObject;
import net.minecraft.server.v1_15_R1.EntityCaveSpider;
import net.minecraft.server.v1_15_R1.EntityCreeper;
import net.minecraft.server.v1_15_R1.EntityEnderman;
import net.minecraft.server.v1_15_R1.EntityHuman;
import net.minecraft.server.v1_15_R1.EntityLiving;
import net.minecraft.server.v1_15_R1.EntitySpider;
import net.minecraft.server.v1_15_R1.EntityTypes;
import net.minecraft.server.v1_15_R1.EnumHand;
import net.minecraft.server.v1_15_R1.IChatBaseComponent;
import net.minecraft.server.v1_15_R1.Packet;
import net.minecraft.server.v1_15_R1.PacketPlayInClientCommand;
import net.minecraft.server.v1_15_R1.PacketPlayOutAbilities;
import net.minecraft.server.v1_15_R1.PacketPlayOutBlockAction;
import net.minecraft.server.v1_15_R1.PacketPlayOutBlockBreakAnimation;
import net.minecraft.server.v1_15_R1.PacketPlayOutCamera;
import net.minecraft.server.v1_15_R1.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_15_R1.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_15_R1.PacketPlayOutExperience;
import net.minecraft.server.v1_15_R1.PacketPlayOutGameStateChange;
import net.minecraft.server.v1_15_R1.PacketPlayOutOpenBook;
import net.minecraft.server.v1_15_R1.PacketPlayOutOpenSignEditor;
import net.minecraft.server.v1_15_R1.PacketPlayOutPlayerListHeaderFooter;
import net.minecraft.server.v1_15_R1.PacketPlayOutSetSlot;
import net.minecraft.server.v1_15_R1.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_15_R1.PacketPlayOutTileEntityData;
import net.minecraft.server.v1_15_R1.PacketPlayOutTitle;
import net.minecraft.server.v1_15_R1.PacketPlayOutUpdateHealth;
import net.minecraft.server.v1_15_R1.PacketPlayOutWorldBorder;
import net.minecraft.server.v1_15_R1.TileEntity;
import net.minecraft.server.v1_15_R1.TileEntitySign;
import net.minecraft.server.v1_15_R1.World;
import net.minecraft.server.v1_15_R1.WorldBorder;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.block.banner.Pattern;
import org.bukkit.craftbukkit.v1_15_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class PacketHelperImpl
implements PacketHelper {
    public static final DataWatcherObject<Float> ENTITY_HUMAN_DATA_WATCHER_ABSORPTION = (DataWatcherObject)ReflectionHelper.getFieldValue(EntityHuman.class, (String)"c", null);
    public static MethodHandle ENTITY_METADATA_EID_SETTER = ReflectionHelper.getFinalSetter(PacketPlayOutEntityMetadata.class, (String)"a");
    public static MethodHandle ENTITY_METADATA_LIST_SETTER = ReflectionHelper.getFinalSetter(PacketPlayOutEntityMetadata.class, (String)"b");
    public static DataWatcherObject<Optional<IChatBaseComponent>> ENTITY_CUSTOM_NAME_METADATA;
    public static DataWatcherObject<Boolean> ENTITY_CUSTOM_NAME_VISIBLE_METADATA;

    public void setFakeAbsorption(Player player, float value) {
        DataWatcher dw = new DataWatcher(null);
        dw.register(ENTITY_HUMAN_DATA_WATCHER_ABSORPTION, (Object)Float.valueOf(value));
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutEntityMetadata(player.getEntityId(), dw, true));
    }

    public void resetWorldBorder(Player player) {
        WorldBorder wb = ((CraftWorld)player.getWorld()).getHandle().getWorldBorder();
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutWorldBorder(wb, PacketPlayOutWorldBorder.EnumWorldBorderAction.INITIALIZE));
    }

    public void setWorldBorder(Player player, Location center, double size, double currSize, long time, int warningDistance, int warningTime) {
        WorldBorder wb = new WorldBorder();
        wb.world = ((CraftWorld)player.getWorld()).getHandle();
        wb.setCenter(center.getX(), center.getZ());
        wb.setWarningDistance(warningDistance);
        wb.setWarningTime(warningTime);
        if (time > 0L) {
            wb.transitionSizeBetween(currSize, size, time);
        } else {
            wb.setSize(size);
        }
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutWorldBorder(wb, PacketPlayOutWorldBorder.EnumWorldBorderAction.INITIALIZE));
    }

    public void setSlot(Player player, int slot, ItemStack itemStack, boolean playerOnly) {
        int windowId = playerOnly ? 0 : ((CraftPlayer)player).getHandle().activeContainer.windowId;
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutSetSlot(windowId, slot, CraftItemStack.asNMSCopy((ItemStack)itemStack)));
    }

    public void setFieldOfView(Player player, float fov) {
        PacketPlayOutAbilities packet = new PacketPlayOutAbilities(((CraftPlayer)player).getHandle().abilities);
        if (!Float.isNaN(fov)) {
            packet.b(fov);
        }
        PacketHelperImpl.sendPacket(player, (Packet)packet);
    }

    public void respawn(Player player) {
        ((CraftPlayer)player).getHandle().playerConnection.a(new PacketPlayInClientCommand(PacketPlayInClientCommand.EnumClientCommand.PERFORM_RESPAWN));
    }

    public void setVision(Player player, EntityType entityType) {
        EntityCreeper entity;
        if (entityType == EntityType.CREEPER) {
            entity = new EntityCreeper(EntityTypes.CREEPER, (World)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.SPIDER) {
            entity = new EntitySpider(EntityTypes.SPIDER, (World)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.CAVE_SPIDER) {
            entity = new EntityCaveSpider(EntityTypes.CAVE_SPIDER, (World)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.ENDERMAN) {
            entity = new EntityEnderman(EntityTypes.ENDERMAN, (World)((CraftWorld)player.getWorld()).getHandle());
        } else {
            return;
        }
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutSpawnEntityLiving((EntityLiving)entity));
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutCamera((net.minecraft.server.v1_15_R1.Entity)entity));
        ((CraftServer)Bukkit.getServer()).getHandle().moveToWorld(((CraftPlayer)player).getHandle(), ((CraftWorld)player.getWorld()).getHandle().worldProvider.getDimensionManager(), true, player.getLocation(), false);
    }

    public void showDemoScreen(Player player) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutGameStateChange(5, 0.0f));
    }

    public void showBlockAction(Player player, Location location, int action, int state) {
        BlockPosition position = new BlockPosition(location.getX(), location.getY(), location.getZ());
        Block block = ((CraftWorld)location.getWorld()).getHandle().getType(position).getBlock();
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutBlockAction(position, block, action, state));
    }

    public void showBlockCrack(Player player, int id, Location location, int progress) {
        BlockPosition position = new BlockPosition(location.getX(), location.getY(), location.getZ());
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutBlockBreakAnimation(id, position, progress));
    }

    public void showTileEntityData(Player player, Location location, int action, CompoundTag compoundTag) {
        BlockPosition position = new BlockPosition(location.getX(), location.getY(), location.getZ());
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutTileEntityData(position, action, ((CompoundTagImpl)compoundTag).toNMSTag()));
    }

    public void showBannerUpdate(Player player, Location location, DyeColor base, List<Pattern> patterns) {
        ArrayList<CompoundTag> nbtPatterns = new ArrayList<CompoundTag>();
        for (Pattern pattern : patterns) {
            nbtPatterns.add(NMSHandler.getInstance().createCompoundTag(new HashMap()).createBuilder().putInt("Color", (int)pattern.getColor().getDyeData()).putString("Pattern", pattern.getPattern().getIdentifier()).build());
        }
        CompoundTag compoundTag = NMSHandler.getBlockHelper().getNbtData(location.getBlock()).createBuilder().put("Patterns", (Tag)new JNBTListTag(CompoundTag.class, nbtPatterns)).build();
        this.showTileEntityData(player, location, 3, compoundTag);
    }

    public void showTabListHeaderFooter(Player player, String header, String footer) {
        PacketPlayOutPlayerListHeaderFooter packet = new PacketPlayOutPlayerListHeaderFooter();
        packet.header = new ChatComponentText(header);
        packet.footer = new ChatComponentText(footer);
        PacketHelperImpl.sendPacket(player, (Packet)packet);
    }

    public void resetTabListHeaderFooter(Player player) {
        this.showTabListHeaderFooter(player, "", "");
    }

    public void showTitle(Player player, String title, String subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutTitle(fadeInTicks, stayTicks, fadeOutTicks));
        if (title != null) {
            PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.TITLE, (IChatBaseComponent)new ChatComponentText(title)));
        }
        if (subtitle != null) {
            PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.SUBTITLE, (IChatBaseComponent)new ChatComponentText(subtitle)));
        }
    }

    public void showEquipment(Player player, LivingEntity entity, EquipmentSlot equipmentSlot, ItemStack itemStack) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutEntityEquipment(entity.getEntityId(), CraftEquipmentSlot.getNMS((EquipmentSlot)equipmentSlot), CraftItemStack.asNMSCopy((ItemStack)itemStack)));
    }

    public void resetEquipment(Player player, LivingEntity entity) {
        EntityEquipment equipment = entity.getEquipment();
        this.showEquipment(player, entity, EquipmentSlot.HAND, equipment.getItemInMainHand());
        this.showEquipment(player, entity, EquipmentSlot.OFF_HAND, equipment.getItemInOffHand());
        this.showEquipment(player, entity, EquipmentSlot.HEAD, equipment.getHelmet());
        this.showEquipment(player, entity, EquipmentSlot.CHEST, equipment.getChestplate());
        this.showEquipment(player, entity, EquipmentSlot.LEGS, equipment.getLeggings());
        this.showEquipment(player, entity, EquipmentSlot.FEET, equipment.getBoots());
    }

    public void openBook(Player player, EquipmentSlot hand) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutOpenBook(hand == EquipmentSlot.OFF_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND));
    }

    public void showHealth(Player player, float health, int food, float saturation) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutUpdateHealth(health, food, saturation));
    }

    public void resetHealth(Player player) {
        this.showHealth(player, (float)player.getHealth(), player.getFoodLevel(), player.getSaturation());
    }

    public void showExperience(Player player, float experience, int level) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutExperience(experience, 0, level));
    }

    public void resetExperience(Player player) {
        this.showExperience(player, player.getExp(), player.getLevel());
    }

    public boolean showSignEditor(Player player, Location location) {
        TileEntity tileEntity = ((CraftWorld)location.getWorld()).getHandle().getTileEntity(new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
        if (tileEntity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileEntity;
            PacketHelperImpl.sendPacket(player, (Packet)sign.getUpdatePacket());
            sign.isEditable = true;
            sign.a((EntityHuman)((CraftPlayer)player).getHandle());
            PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutOpenSignEditor(sign.getPosition()));
            return true;
        }
        return false;
    }

    public void sendRename(Player player, Entity entity, String name, boolean listMode) {
        try {
            PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata();
            ENTITY_METADATA_EID_SETTER.invoke(packet, entity.getEntityId());
            ArrayList<DataWatcher.Item> list = new ArrayList<DataWatcher.Item>();
            ChatComponentText text = new ChatComponentText("");
            for (IChatBaseComponent component : CraftChatMessage.fromString((String)name)) {
                text.addSibling(component);
            }
            list.add(new DataWatcher.Item(ENTITY_CUSTOM_NAME_METADATA, Optional.of(text)));
            list.add(new DataWatcher.Item(ENTITY_CUSTOM_NAME_VISIBLE_METADATA, (Object)true));
            ENTITY_METADATA_LIST_SETTER.invoke(packet, list);
            PacketHelperImpl.sendPacket(player, (Packet)packet);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void forceSpectate(Player player, Entity entity) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutCamera(((CraftEntity)entity).getHandle()));
    }

    public void setNetworkManagerFor(Player player) {
        DenizenNetworkManagerImpl.setNetworkManager(player);
    }

    public static void sendPacket(Player player, Packet packet) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket(packet);
    }

    static {
        try {
            ENTITY_CUSTOM_NAME_METADATA = (DataWatcherObject)ReflectionHelper.getFieldValue(net.minecraft.server.v1_15_R1.Entity.class, (String)"az", null);
            ENTITY_CUSTOM_NAME_VISIBLE_METADATA = (DataWatcherObject)ReflectionHelper.getFieldValue(net.minecraft.server.v1_15_R1.Entity.class, (String)"aA", null);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

