/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_15.helpers;

import com.denizenscript.denizen.nms.interfaces.AdvancementHelper;
import com.denizenscript.denizen.nms.v1_15.helpers.PacketHelperImpl;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.v1_15_R1.Advancement;
import net.minecraft.server.v1_15_R1.AdvancementDataPlayer;
import net.minecraft.server.v1_15_R1.AdvancementDataWorld;
import net.minecraft.server.v1_15_R1.AdvancementDisplay;
import net.minecraft.server.v1_15_R1.AdvancementFrameType;
import net.minecraft.server.v1_15_R1.AdvancementProgress;
import net.minecraft.server.v1_15_R1.AdvancementRewards;
import net.minecraft.server.v1_15_R1.Advancements;
import net.minecraft.server.v1_15_R1.ChatComponentText;
import net.minecraft.server.v1_15_R1.Criterion;
import net.minecraft.server.v1_15_R1.CriterionInstance;
import net.minecraft.server.v1_15_R1.CriterionTriggerImpossible;
import net.minecraft.server.v1_15_R1.EntityPlayer;
import net.minecraft.server.v1_15_R1.IChatBaseComponent;
import net.minecraft.server.v1_15_R1.MinecraftKey;
import net.minecraft.server.v1_15_R1.Packet;
import net.minecraft.server.v1_15_R1.PacketPlayOutAdvancements;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AdvancementHelperImpl
extends AdvancementHelper {
    private static final String IMPOSSIBLE_KEY = "impossible";
    private static final Map<String, Criterion> IMPOSSIBLE_CRITERIA = Collections.singletonMap("impossible", new Criterion((CriterionInstance)new CriterionTriggerImpossible.a()));
    private static final String[][] IMPOSSIBLE_REQUIREMENTS = new String[][]{{"impossible"}};

    public static AdvancementDataWorld getAdvancementDataWorld() {
        return ((CraftServer)Bukkit.getServer()).getServer().getAdvancementData();
    }

    @Override
    public void register(com.denizenscript.denizen.nms.util.Advancement advancement) {
        if (advancement.temporary || advancement.registered) {
            return;
        }
        Advancement nms = AdvancementHelperImpl.asNMSCopy(advancement);
        if (advancement.parent == null) {
            Set roots = (Set)ReflectionHelper.getFieldValue(Advancements.class, "c", AdvancementHelperImpl.getAdvancementDataWorld().REGISTRY);
            roots.add(nms);
            Advancements.a something = (Advancements.a)ReflectionHelper.getFieldValue(Advancements.class, "e", AdvancementHelperImpl.getAdvancementDataWorld().REGISTRY);
            if (something != null) {
                something.a(nms);
            }
        } else {
            Set branches = (Set)ReflectionHelper.getFieldValue(Advancements.class, "d", AdvancementHelperImpl.getAdvancementDataWorld().REGISTRY);
            branches.add(nms);
            Advancements.a something = (Advancements.a)ReflectionHelper.getFieldValue(Advancements.class, "e", AdvancementHelperImpl.getAdvancementDataWorld().REGISTRY);
            if (something != null) {
                something.c(nms);
            }
        }
        AdvancementHelperImpl.getAdvancementDataWorld().REGISTRY.advancements.put(nms.getName(), nms);
        advancement.registered = true;
        if (!advancement.hidden && advancement.parent != null) {
            ((CraftServer)Bukkit.getServer()).getHandle().sendAll((Packet)new PacketPlayOutAdvancements(false, Collections.singleton(nms), Collections.emptySet(), Collections.emptyMap()));
        }
    }

    @Override
    public void unregister(com.denizenscript.denizen.nms.util.Advancement advancement) {
        if (advancement.temporary || !advancement.registered) {
            return;
        }
        Map advancements = AdvancementHelperImpl.getAdvancementDataWorld().REGISTRY.advancements;
        MinecraftKey key = AdvancementHelperImpl.asMinecraftKey(advancement.key);
        Advancement nms = (Advancement)advancements.get(key);
        if (advancement.parent == null) {
            Set roots = (Set)ReflectionHelper.getFieldValue(Advancements.class, "c", AdvancementHelperImpl.getAdvancementDataWorld().REGISTRY);
            roots.remove(nms);
        } else {
            Set branches = (Set)ReflectionHelper.getFieldValue(Advancements.class, "d", AdvancementHelperImpl.getAdvancementDataWorld().REGISTRY);
            branches.remove(nms);
        }
        advancements.remove(key);
        advancement.registered = false;
        ((CraftServer)Bukkit.getServer()).getHandle().sendAll((Packet)new PacketPlayOutAdvancements(false, Collections.emptySet(), Collections.singleton(key), Collections.emptyMap()));
    }

    @Override
    public void grant(com.denizenscript.denizen.nms.util.Advancement advancement, Player player) {
        if (advancement.temporary) {
            Advancement nmsAdvancement = AdvancementHelperImpl.asNMSCopy(advancement);
            AdvancementProgress progress = new AdvancementProgress();
            progress.a(IMPOSSIBLE_CRITERIA, IMPOSSIBLE_REQUIREMENTS);
            progress.a(IMPOSSIBLE_KEY);
            PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutAdvancements(false, Collections.singleton(nmsAdvancement), Collections.emptySet(), Collections.singletonMap(nmsAdvancement.getName(), progress)));
        } else {
            Advancement nmsAdvancement = (Advancement)AdvancementHelperImpl.getAdvancementDataWorld().REGISTRY.advancements.get(AdvancementHelperImpl.asMinecraftKey(advancement.key));
            ((CraftPlayer)player).getHandle().getAdvancementData().grantCriteria(nmsAdvancement, IMPOSSIBLE_KEY);
        }
    }

    @Override
    public void revoke(com.denizenscript.denizen.nms.util.Advancement advancement, Player player) {
        if (advancement.temporary) {
            PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutAdvancements(false, Collections.emptySet(), Collections.singleton(AdvancementHelperImpl.asMinecraftKey(advancement.key)), Collections.emptyMap()));
        } else {
            Advancement nmsAdvancement = (Advancement)AdvancementHelperImpl.getAdvancementDataWorld().REGISTRY.advancements.get(AdvancementHelperImpl.asMinecraftKey(advancement.key));
            ((CraftPlayer)player).getHandle().getAdvancementData().revokeCritera(nmsAdvancement, IMPOSSIBLE_KEY);
        }
    }

    @Override
    public void update(Player player) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        nmsPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutAdvancements(true, Collections.emptySet(), Collections.emptySet(), Collections.emptyMap()));
        AdvancementDataPlayer data = nmsPlayer.getAdvancementData();
        data.c();
        data.b();
        data.b(nmsPlayer);
    }

    private static Advancement asNMSCopy(com.denizenscript.denizen.nms.util.Advancement advancement) {
        MinecraftKey key = AdvancementHelperImpl.asMinecraftKey(advancement.key);
        Advancement parent = advancement.parent != null ? (Advancement)AdvancementHelperImpl.getAdvancementDataWorld().REGISTRY.advancements.get(AdvancementHelperImpl.asMinecraftKey(advancement.parent)) : null;
        AdvancementDisplay display = new AdvancementDisplay(CraftItemStack.asNMSCopy((ItemStack)advancement.icon), (IChatBaseComponent)new ChatComponentText(advancement.title), (IChatBaseComponent)new ChatComponentText(advancement.description), AdvancementHelperImpl.asMinecraftKey(advancement.background), AdvancementFrameType.valueOf((String)advancement.frame.name()), advancement.toast, advancement.announceToChat, advancement.hidden);
        display.a(advancement.xOffset, advancement.yOffset);
        return new Advancement(key, parent, display, AdvancementRewards.a, IMPOSSIBLE_CRITERIA, IMPOSSIBLE_REQUIREMENTS);
    }

    private static MinecraftKey asMinecraftKey(NamespacedKey key) {
        return key != null ? new MinecraftKey(key.getNamespace(), key.getKey()) : null;
    }
}

