/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.data.type.Bed;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;

public class SleepingTrait
extends Trait {
    @Persist(value="sleeping")
    private boolean sleeping = false;
    @Persist(value="bed location")
    private Location bedLocation = null;

    public void run() {
        if (this.npc == null || this.bedLocation == null || !this.npc.isSpawned()) {
            return;
        }
        if (!Utilities.checkLocation((LivingEntity)this.npc.getEntity(), this.bedLocation, 1.0)) {
            this.wakeUp();
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), () -> {
                if (this.npc.hasTrait(SleepingTrait.class) && !((SleepingTrait)this.npc.getOrAddTrait(SleepingTrait.class)).isSleeping()) {
                    this.npc.removeTrait(SleepingTrait.class);
                }
            });
        }
    }

    public void onSpawn() {
        if (this.sleeping) {
            this.internalSleepNow();
        }
    }

    public void internalSleepNow() {
        if (this.npc.getEntity() instanceof Villager) {
            if (!((Villager)this.npc.getEntity()).sleep(this.bedLocation.clone())) {
                return;
            }
        } else if (this.npc.getEntity() instanceof Player) {
            if (this.bedLocation.getBlock().getBlockData() instanceof Bed) {
                ((Player)this.npc.getEntity()).sleep(this.bedLocation.clone(), true);
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17)) {
                NMSHandler.getEntityHelper().setSleeping(this.npc.getEntity(), true);
            } else {
                PlayerAnimation.SLEEP.play((Player)this.npc.getEntity());
            }
        } else {
            return;
        }
        this.sleeping = true;
    }

    public void toSleep() {
        if (this.sleeping) {
            return;
        }
        if (!this.npc.isSpawned()) {
            Debug.echoError("NPC " + this.npc.getId() + " cannot sleep: not spawned.");
            return;
        }
        this.bedLocation = this.npc.getStoredLocation().clone();
        if (!this.bedLocation.isWorldLoaded()) {
            Debug.echoError("NPC " + this.npc.getId() + " cannot sleep: invalid bed location.");
            return;
        }
        this.internalSleepNow();
    }

    public void toSleep(Location location) {
        if (this.sleeping) {
            return;
        }
        if (!this.npc.isSpawned()) {
            Debug.echoError("NPC " + this.npc.getId() + " cannot sleep: not spawned.");
            return;
        }
        if (!location.isWorldLoaded()) {
            Debug.echoError("NPC " + this.npc.getId() + " cannot sleep: invalid bed location.");
            return;
        }
        this.npc.getEntity().teleport(location.clone().add(0.5, 0.0, 0.5));
        this.bedLocation = location.clone();
        this.internalSleepNow();
    }

    public void wakeUp() {
        if (!this.sleeping) {
            return;
        }
        this.sleeping = false;
        if (this.npc.getEntity() instanceof Villager) {
            ((Villager)this.npc.getEntity()).wakeup();
        } else {
            if (((Player)this.npc.getEntity()).isSleeping()) {
                ((Player)this.npc.getEntity()).wakeup(false);
            }
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17)) {
                NMSHandler.getEntityHelper().setSleeping(this.npc.getEntity(), false);
            } else {
                PlayerAnimation.STOP_SLEEPING.play((Player)this.npc.getEntity());
            }
        }
        this.bedLocation = null;
    }

    public boolean isSleeping() {
        return this.sleeping;
    }

    public Location getBed() {
        return this.bedLocation;
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.bedLocation == null) {
            return;
        }
        if (event.getBlock().getLocation().equals((Object)this.bedLocation)) {
            event.setCancelled(true);
        }
    }

    public SleepingTrait() {
        super("sleeping");
    }
}

