/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.server.ListPingScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.paper.PaperModule;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.server.ServerListPingEvent;

public class ServerListPingScriptEventPaperImpl
extends ListPingScriptEvent {
    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        String lower = CoreUtilities.toLowerCase(determination);
        if (lower.startsWith("protocol_version:") && ArgumentHelper.matchesInteger(determination.substring("protocol_version:".length()))) {
            ((PaperServerListPingEvent)this.event).setProtocolVersion(Integer.parseInt(determination.substring("protocol_version:".length())));
            return true;
        }
        if (lower.startsWith("version_name:")) {
            ((PaperServerListPingEvent)this.event).setVersion(determination.substring("version_name:".length()));
            return true;
        }
        if (lower.startsWith("exclude_players:")) {
            HashSet<UUID> exclusions = new HashSet<UUID>();
            for (PlayerTag player : ListTag.valueOf(determination.substring("exclude_players:".length()), this.getTagContext(path)).filter(PlayerTag.class, this.getTagContext(path))) {
                exclusions.add(player.getUUID());
            }
            Iterator players = ((PaperServerListPingEvent)this.event).iterator();
            while (players.hasNext()) {
                if (!exclusions.contains(((Player)players.next()).getUniqueId())) continue;
                players.remove();
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public void setMotd(String text) {
        this.event.motd(PaperModule.parseFormattedText(text, ChatColor.WHITE));
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "motd": {
                return new ElementTag(PaperModule.stringifyComponent(this.event.motd(), ChatColor.WHITE));
            }
            case "protocol_version": {
                return new ElementTag(((PaperServerListPingEvent)this.event).getProtocolVersion());
            }
            case "version_name": {
                return new ElementTag(((PaperServerListPingEvent)this.event).getVersion());
            }
            case "client_protocol_version": {
                return new ElementTag(((PaperServerListPingEvent)this.event).getClient().getProtocolVersion());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onListPing(PaperServerListPingEvent event) {
        this.syncFire((ServerListPingEvent)event);
    }
}

