/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.Material;

public class EntityItemInOffHand
implements Property {
    public static final String[] handledTags = new String[]{"item_in_offhand"};
    public static final String[] handledMechs = new String[]{"item_in_offhand"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        return ((EntityTag)entity).isLivingEntity();
    }

    public static EntityItemInOffHand getFrom(ObjectTag entity) {
        if (!EntityItemInOffHand.describes(entity)) {
            return null;
        }
        return new EntityItemInOffHand((EntityTag)entity);
    }

    private EntityItemInOffHand(EntityTag entity) {
        this.entity = entity;
    }

    @Override
    public String getPropertyString() {
        ItemTag item = new ItemTag(this.entity.getLivingEntity().getEquipment().getItemInOffHand());
        if (item.getBukkitMaterial() != Material.AIR) {
            return item.identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "item_in_offhand";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("item_in_offhand")) {
            if (!this.entity.isSpawnedOrValidForTag()) {
                return null;
            }
            return new ItemTag(this.entity.getLivingEntity().getEquipment().getItemInOffHand()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("item_in_offhand")) {
            this.entity.getLivingEntity().getEquipment().setItemInOffHand(mechanism.valueAsType(ItemTag.class).getItemStack());
        }
    }
}

