/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Conversion;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.entity.Position;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class FlyCommand
extends AbstractCommand {
    public FlyCommand() {
        this.setName("fly");
        this.setSyntax("fly (cancel) [<entity>|...] (controller:<player>) (origin:<location>) (destinations:<location>|...) (speed:<#.#>) (rotationthreshold:<#.#>)");
        this.setRequiredArguments(1, 7);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("cancel") && arg.matches("cancel")) {
                scriptEntry.addObject("cancel", "");
                continue;
            }
            if (!scriptEntry.hasObject("destinations") && arg.matchesPrefix("destination", "destinations", "d")) {
                scriptEntry.addObject("destinations", arg.asType(ListTag.class).filter(LocationTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("controller") && arg.matchesArgumentType(PlayerTag.class) && arg.matchesPrefix("controller", "c")) {
                scriptEntry.addObject("controller", arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("origin") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("origin", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("rotation_threshold") && arg.matchesPrefix("rotationthreshold", "rotation", "r") && arg.matchesFloat()) {
                scriptEntry.addObject("rotation_threshold", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesFloat()) {
                scriptEntry.addObject("speed", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("origin", Utilities.entryDefaultLocation(scriptEntry, true));
        scriptEntry.defaultObject("speed", new ElementTag(1.2));
        scriptEntry.defaultObject("rotation_threshold", new ElementTag(15));
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        if (!scriptEntry.hasObject("origin")) {
            throw new InvalidArgumentsException("Must specify an origin!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag origin = (LocationTag)scriptEntry.getObjectTag("origin");
        List entities = (List)scriptEntry.getObject("entities");
        final List destinations = scriptEntry.hasObject("destinations") ? (List)scriptEntry.getObject("destinations") : new ArrayList();
        final boolean freeflight = destinations.size() < 1;
        EntityTag controller = (EntityTag)scriptEntry.getObjectTag("controller");
        if (freeflight) {
            if (controller == null) {
                for (EntityTag entity : entities) {
                    if (!entity.isPlayer() || entities.get(entities.size() - 1) == entity) continue;
                    controller = entity;
                    if (!scriptEntry.dbCallShouldDebug()) break;
                    Debug.echoDebug((Debuggable)scriptEntry, "Flight control defaulting to " + controller);
                    break;
                }
                if (controller == null) {
                    if (scriptEntry.dbCallShouldDebug()) {
                        Debug.echoDebug((Debuggable)scriptEntry, "There is no one to control the flight's path!");
                    }
                    return;
                }
            } else {
                boolean found = false;
                for (EntityTag entity : entities) {
                    if (!entity.identify().equals(controller.identify())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    if (scriptEntry.dbCallShouldDebug()) {
                        Debug.echoDebug((Debuggable)scriptEntry, "Adding controller " + controller + " to flying entities.");
                    }
                    entities.add(0, controller);
                }
            }
        }
        final double speed = ((ElementTag)scriptEntry.getObject("speed")).asDouble();
        final float rotationThreshold = ((ElementTag)scriptEntry.getObject("rotation_threshold")).asFloat();
        boolean cancel = scriptEntry.hasObject("cancel");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), cancel ? FlyCommand.db("cancel", true) : "", origin, FlyCommand.db("entities", entities), FlyCommand.db("speed", speed), FlyCommand.db("rotation threshold degrees", Float.valueOf(rotationThreshold)), freeflight ? controller : FlyCommand.db("destinations", destinations));
        }
        if (!cancel) {
            for (EntityTag entity : entities) {
                entity.spawnAt(origin);
            }
        } else {
            Position.dismount(Conversion.convertEntities(entities));
            return;
        }
        Position.mount(Conversion.convertEntities(entities));
        final Entity entity = ((EntityTag)entities.get(entities.size() - 1)).getBukkitEntity();
        final LivingEntity finalController = controller != null ? controller.getLivingEntity() : null;
        BukkitRunnable task = new BukkitRunnable(){
            Location location = null;
            Boolean flying = true;

            public void run() {
                if (freeflight) {
                    if (!entity.isEmpty() && finalController.isInsideVehicle()) {
                        this.location = finalController.getEyeLocation().add(finalController.getEyeLocation().getDirection().multiply(30));
                    } else {
                        this.flying = false;
                    }
                } else if (destinations.size() > 0) {
                    this.location = (Location)destinations.get(0);
                } else {
                    this.flying = false;
                }
                if (this.flying.booleanValue() && entity.isValid()) {
                    if (!NMSHandler.getEntityHelper().isFacingLocation(entity, this.location, rotationThreshold)) {
                        NMSHandler.getEntityHelper().faceLocation(entity, this.location);
                    }
                    Vector v1 = entity.getLocation().toVector();
                    Vector v2 = this.location.toVector();
                    Vector v3 = v2.clone().subtract(v1).normalize().multiply(speed);
                    entity.setVelocity(v3);
                    if (!freeflight && Math.abs(v2.getX() - v1.getX()) < 2.0 && Math.abs(v2.getY() - v1.getY()) < 2.0 && Math.abs(v2.getZ() - v1.getZ()) < 2.0) {
                        destinations.remove(0);
                    }
                } else {
                    this.flying = false;
                    this.cancel();
                }
            }
        };
        task.runTaskTimer((Plugin)Denizen.getInstance(), 0L, 3L);
    }
}

