/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.packets;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.ItemTag;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ItemChangeMessage
implements Listener {
    private static final Map<UUID, Integer> slotChanged;

    public static void sendMessage(Player player, String message) {
        ItemStack item = player.getEquipment().getItemInMainHand();
        item = item == null || item.getType() == Material.AIR ? new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE) : item.clone();
        ItemTag itemTag = new ItemTag(item);
        NMSHandler.getItemHelper().setDisplayName(itemTag, message);
        int slot = player.getInventory().getHeldItemSlot() + 36;
        NMSHandler.getPacketHelper().setSlot(player, slot, item, true);
        slotChanged.put(player.getUniqueId(), slot);
    }

    public static void resetItem(Player player) {
        if (player == null) {
            return;
        }
        UUID uuid = player.getUniqueId();
        if (slotChanged.containsKey(uuid)) {
            int slot = slotChanged.get(uuid);
            ItemStack itemStack = player.getEquipment().getItemInMainHand();
            NMSHandler.getPacketHelper().setSlot(player, slot, itemStack, true);
            slotChanged.remove(uuid);
        }
    }

    @EventHandler
    public void playerItemHeld(PlayerItemHeldEvent event) {
        ItemChangeMessage.resetItem(event.getPlayer());
    }

    @EventHandler
    public void inventoryOpen(InventoryOpenEvent event) {
        if (event.getPlayer() instanceof Player) {
            ItemChangeMessage.resetItem((Player)event.getPlayer());
        }
    }

    @EventHandler
    public void blockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (player != null) {
            slotChanged.remove(player.getUniqueId());
        }
    }

    @EventHandler
    public void playerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (player != null) {
            slotChanged.remove(player.getUniqueId());
        }
    }

    static {
        Denizen.getInstance().getServer().getPluginManager().registerEvents((Listener)new ItemChangeMessage(), (Plugin)Denizen.getInstance());
        slotChanged = new HashMap<UUID, Integer>();
    }
}

