/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities.codegen;

import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.codegen.CodeGenUtil;
import com.denizenscript.denizencore.utilities.codegen.TagNamer;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class TagCodeGenerator {
    public static long totalGenerated = 0L;
    private static final int LOCAL_ATTRIBUTE = 1;
    private static final int LOCAL_CURRENTOBJECT = 2;
    public static String FULFILL_ONE_RUN_DESCRIPTOR = "(L" + CodeGenUtil.OBJECT_TAG_PATH + ";)V";

    public static boolean hasStaticContext(Attribute.AttributeComponent component, TagContext genContext) {
        if (component.rawParam == null) {
            return true;
        }
        if (component.paramParsed == null) {
            component.paramParsed = TagManager.parseTextToTag(component.rawParam, genContext);
            if (component.paramParsed == null) {
                return false;
            }
        }
        return !component.paramParsed.hasTag;
    }

    public static TagRunnable.BaseInterface<? extends ObjectTag> generatePartialTag(TagManager.ParseableTagPiece toParse, TagContext genContext) {
        ReplaceableTagEvent staticParseEvent;
        Attribute staticParseAttrib;
        ObjectTagProcessor.TagData<? extends ObjectTag, ? extends ObjectTag> piece;
        ReplaceableTagEvent.ReferenceData data = toParse.tagData;
        if (data == null || data.tagBase == null || data.tagBase.baseForm == null || data.attribs.attributes.length < 1) {
            return null;
        }
        if (data.compiledStart != null) {
            return data.compiledStart;
        }
        Attribute.AttributeComponent[] pieces = data.attribs.attributes;
        boolean canBeStatic = data.tagBase.isStatic && TagCodeGenerator.hasStaticContext(pieces[0], genContext);
        int staticParts = canBeStatic ? 1 : 0;
        int applicableParts = 0;
        for (int i = 1; i < pieces.length && (piece = pieces[i].data) != null && piece.runner != null; ++i) {
            ++applicableParts;
            if (!canBeStatic) continue;
            if (piece.isStatic && TagCodeGenerator.hasStaticContext(pieces[i], genContext)) {
                ++staticParts;
                continue;
            }
            canBeStatic = false;
        }
        Object staticParseResult = null;
        if (staticParts > 0 && (staticParseResult = (Object)data.tagBase.baseForm.run(staticParseAttrib = (staticParseEvent = new ReplaceableTagEvent(data, toParse.content, genContext)).getAttributes())) != null) {
            staticParseAttrib.fulfillOne((ObjectTag)staticParseResult);
            for (int i = 1; i < staticParts; ++i) {
                TagRunnable.ObjectInterface runner = pieces[i].data.runner;
                if ((staticParseResult = (Object)runner.run(staticParseAttrib, staticParseResult)) == null) continue;
                staticParseAttrib.fulfillOne((ObjectTag)staticParseResult);
            }
            if (staticParseResult != null) {
                if (staticParts == pieces.length) {
                    if (genContext.shouldDebug()) {
                        Debug.echoDebug((Debuggable)genContext, "<Y>+> [Static Tag Processing] <G>Pre-Filled tag <<W>" + toParse.content + "<G>> with '<W>" + staticParseResult.toString() + "<G>', and cached result.");
                    }
                    toParse.rawObject = staticParseResult;
                    toParse.tagData.rawObject = staticParseResult;
                    toParse.content = staticParseResult.toString();
                    toParse.isTag = false;
                    return null;
                }
                if (genContext.shouldDebug()) {
                    StringBuilder piecesText = new StringBuilder("<");
                    for (int i = 0; i < staticParts; ++i) {
                        piecesText.append(pieces[i].toString()).append(".");
                    }
                    Debug.echoDebug((Debuggable)genContext, "<Y>+> [Static Tag Processing] <G>Pre-Filled partial tag '<W>" + piecesText + "..<G>' with '<W>" + staticParseResult.toString() + "<G>', and cached result.");
                }
                data.skippable = staticParts;
            }
        }
        if (applicableParts == 0 && staticParts == 0) {
            return null;
        }
        try {
            int i;
            String tagFullName = CodeGenUtil.TAG_NAME_PERMITTED.trimToMatches(data.rawTag.replace('.', '_'));
            if (tagFullName.length() > 50) {
                tagFullName = tagFullName.substring(0, 50);
            }
            String className = "com/denizenscript/tag_gen/UserTag" + totalGenerated++ + "_" + tagFullName;
            ClassWriter cw = new ClassWriter(3);
            cw.visit(52, 1, className, null, "java/lang/Object", new String[]{TagNamer.BASE_INTERFACE_PATH});
            cw.visitSource("GENERATED_TAG", null);
            if (staticParseResult != null) {
                cw.visitField(9, "staticParseResult", CodeGenUtil.OBJECT_LOCAL_TYPE, null, null);
            }
            MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            Label startLabel = new Label();
            mv.visitLabel(startLabel);
            mv.visitLineNumber(0, startLabel);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
            mv.visitInsn(177);
            mv.visitLocalVariable("this", "L" + className + ";", null, startLabel, startLabel, 0);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = cw.visitMethod(17, "run", TagNamer.BASE_INTERFACE_RUN_DESCRIPTOR, null, null);
            mv.visitCode();
            Label returnLabel = new Label();
            Label failLabel = new Label();
            int line = 1;
            Label startLabel2 = new Label();
            mv.visitLabel(startLabel2);
            mv.visitLineNumber(line++, startLabel2);
            if (staticParseResult != null) {
                mv.visitFieldInsn(178, className, "staticParseResult", CodeGenUtil.OBJECT_LOCAL_TYPE);
                mv.visitVarInsn(58, 2);
            } else {
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(184, Type.getInternalName(data.tagBase.baseForm.getClass()), "staticRun", TagNamer.BASE_INTERFACE_RUN_DESCRIPTOR, false);
                mv.visitVarInsn(58, 2);
                mv.visitVarInsn(25, 2);
                mv.visitJumpInsn(198, failLabel);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, CodeGenUtil.ATTRIBUTE_TYPE_PATH, "fulfillOne", FULFILL_ONE_RUN_DESCRIPTOR, false);
            }
            int n = i = staticParseResult == null ? 1 : staticParts;
            while (i < applicableParts) {
                ObjectTagProcessor.TagData<? extends ObjectTag, ? extends ObjectTag> piece2 = pieces[i].data;
                Label methodLabel = new Label();
                mv.visitLabel(methodLabel);
                mv.visitLineNumber(line++, methodLabel);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(184, Type.getInternalName(piece2.runner.getClass()), "staticRun", TagNamer.OBJECT_INTERFACE_RUN_DESCRIPTOR, false);
                mv.visitVarInsn(58, 2);
                Label checkLabel1 = new Label();
                mv.visitLabel(checkLabel1);
                mv.visitLineNumber(line++, checkLabel1);
                mv.visitVarInsn(25, 2);
                mv.visitJumpInsn(198, failLabel);
                Label fulfillLabel = new Label();
                mv.visitLabel(fulfillLabel);
                mv.visitLineNumber(line++, fulfillLabel);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, CodeGenUtil.ATTRIBUTE_TYPE_PATH, "fulfillOne", FULFILL_ONE_RUN_DESCRIPTOR, false);
                Label checkLabel2 = new Label();
                mv.visitLabel(checkLabel2);
                mv.visitLineNumber(line++, checkLabel2);
                mv.visitVarInsn(25, 1);
                mv.visitFieldInsn(180, CodeGenUtil.ATTRIBUTE_TYPE_PATH, "hadManualFulfill", "Z");
                mv.visitJumpInsn(154, returnLabel);
                ++i;
            }
            mv.visitJumpInsn(167, returnLabel);
            mv.visitLabel(failLabel);
            mv.visitLineNumber(line++, failLabel);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, CodeGenUtil.ATTRIBUTE_TYPE_PATH, "trackLastTagFailure", "()V", false);
            mv.visitLabel(returnLabel);
            mv.visitLineNumber(line, returnLabel);
            mv.visitVarInsn(25, 2);
            mv.visitInsn(176);
            mv.visitLocalVariable("attribute", CodeGenUtil.ATTRIBUTE_LOCAL_TYPE, null, startLabel2, startLabel2, 1);
            mv.visitLocalVariable("currentObject", CodeGenUtil.OBJECT_LOCAL_TYPE, null, startLabel2, startLabel2, 2);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            cw.visitEnd();
            byte[] compiled = cw.toByteArray();
            Class<?> generatedClass = CodeGenUtil.loader.define(className.replace('/', '.'), compiled);
            if (staticParseResult != null) {
                ReflectionHelper.getFinalSetter(generatedClass, "staticParseResult").invoke((ObjectTag)staticParseResult);
            }
            Object result = generatedClass.getConstructors()[0].newInstance(new Object[0]);
            return (TagRunnable.BaseInterface)result;
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return null;
        }
    }
}

