/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.objects.AreaContainmentObject;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.SavableMapFlagTracker;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.Note;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class EllipsoidTag
implements ObjectTag,
Notable,
Cloneable,
AreaContainmentObject,
FlaggableObject {
    public LocationTag center;
    public LocationTag size;
    public String noteName = null;
    public AbstractFlagTracker flagTracker = null;
    String prefix = "ellipsoid";
    public static ObjectTagProcessor<EllipsoidTag> tagProcessor = new ObjectTagProcessor();

    public static List<EllipsoidTag> getNotableEllipsoidsContaining(Location location) {
        ArrayList<EllipsoidTag> ellipsoids = new ArrayList<EllipsoidTag>();
        for (EllipsoidTag ellipsoid : NoteManager.getAllType(EllipsoidTag.class)) {
            if (!ellipsoid.contains(location)) continue;
            ellipsoids.add(ellipsoid);
        }
        return ellipsoids;
    }

    @Deprecated
    public static EllipsoidTag valueOf(String string) {
        return EllipsoidTag.valueOf(string, null);
    }

    @Fetchable(value="ellipsoid")
    public static EllipsoidTag valueOf(String string, TagContext context) {
        if (string.startsWith("ellipsoid@")) {
            string = string.substring(10);
        }
        if (string.contains("@")) {
            return null;
        }
        Notable noted = NoteManager.getSavedObject(string);
        if (noted instanceof EllipsoidTag) {
            return (EllipsoidTag)noted;
        }
        List<String> split = CoreUtilities.split(string, ',');
        if (split.size() != 7) {
            return null;
        }
        WorldTag world = WorldTag.valueOf(split.get(3), false);
        if (world == null) {
            return null;
        }
        for (int i = 0; i < 7; ++i) {
            if (i == 3 || ArgumentHelper.matchesDouble(split.get(i)) || context != null && !context.showErrors()) continue;
            Debug.echoError("EllipsoidTag input is not a valid decimal number: " + split.get(i));
            return null;
        }
        LocationTag location = new LocationTag(world.getWorld(), Double.parseDouble(split.get(0)), Double.parseDouble(split.get(1)), Double.parseDouble(split.get(2)));
        LocationTag size = new LocationTag(null, Double.parseDouble(split.get(4)), Double.parseDouble(split.get(5)), Double.parseDouble(split.get(6)));
        return new EllipsoidTag(location, size);
    }

    public static boolean matches(String arg) {
        try {
            return EllipsoidTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public EllipsoidTag clone() {
        return new EllipsoidTag(this.center.clone(), this.size.clone());
    }

    @Override
    public ObjectTag duplicate() {
        if (this.noteName != null) {
            return this;
        }
        return this.clone();
    }

    public EllipsoidTag(LocationTag center, LocationTag size) {
        this.center = center;
        this.size = size;
    }

    @Override
    public ListTag getBlocks(Predicate<Location> test) {
        List<LocationTag> initial = this.getCuboidBoundary().getBlocks_internal(test);
        ListTag list = new ListTag();
        for (LocationTag loc : initial) {
            if (!this.contains(loc)) continue;
            list.addObject(loc);
        }
        return list;
    }

    public List<LocationTag> getBlockLocationsUnfiltered(boolean doMax) {
        List<LocationTag> initial = this.getCuboidBoundary().getBlockLocationsUnfiltered(doMax);
        ArrayList<LocationTag> locations = new ArrayList<LocationTag>();
        for (LocationTag loc : initial) {
            if (!this.contains(loc)) continue;
            locations.add(loc);
        }
        return locations;
    }

    @Override
    public ListTag getShell() {
        ListTag output = new ListTag();
        double yScale = this.size.getY();
        int maxY = (int)Math.floor(yScale);
        output.addObject(new LocationTag(this.center.getBlockX(), (double)(this.center.getBlockY() - maxY), (double)this.center.getBlockZ(), this.center.getWorldName()));
        if (maxY != 0) {
            output.addObject(new LocationTag(this.center.getBlockX(), (double)(this.center.getBlockY() + maxY), (double)this.center.getBlockZ(), this.center.getWorldName()));
        }
        for (int y = -maxY; y <= maxY; ++y) {
            double yProgMin = Math.min(1.0, (double)(Math.abs(y) + 1) / yScale);
            double yProgMax = (double)Math.abs(y) / yScale;
            double minSubWidth = Math.sqrt(1.0 - yProgMin * yProgMin);
            double maxSubWidth = Math.sqrt(1.0 - yProgMax * yProgMax);
            double minX = this.size.getX() * minSubWidth - 1.0;
            double minZ = this.size.getZ() * minSubWidth - 1.0;
            double maxX = this.size.getX() * maxSubWidth;
            double maxZ = this.size.getZ() * maxSubWidth;
            int x = 0;
            while ((double)x < maxX) {
                int z = 0;
                while ((double)z < maxZ) {
                    double scaleTestMin = (double)(x * x) / (minX * minX) + (double)(z * z) / (minZ * minZ);
                    double scaleTestMax = (double)(x * x) / (maxX * maxX) + (double)(z * z) / (maxZ * maxZ);
                    if (scaleTestMin >= 1.0 && scaleTestMax <= 1.0) {
                        output.addObject(new LocationTag(this.center.getBlockX() + x, (double)(this.center.getBlockY() + y), (double)(this.center.getBlockZ() + z), this.center.getWorldName()));
                        if (x != 0) {
                            output.addObject(new LocationTag(this.center.getBlockX() - x, (double)(this.center.getBlockY() + y), (double)(this.center.getBlockZ() + z), this.center.getWorldName()));
                        }
                        if (z != 0) {
                            output.addObject(new LocationTag(this.center.getBlockX() + x, (double)(this.center.getBlockY() + y), (double)(this.center.getBlockZ() - z), this.center.getWorldName()));
                        }
                        if (x != 0 && z != 0) {
                            output.addObject(new LocationTag(this.center.getBlockX() - x, (double)(this.center.getBlockY() + y), (double)(this.center.getBlockZ() - z), this.center.getWorldName()));
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }
        return output;
    }

    public boolean contains(Location test) {
        if (test.getWorld() == null || !test.getWorld().getName().equals(this.center.getWorld().getName())) {
            return false;
        }
        double xbase = test.getX() - this.center.getX();
        double ybase = test.getY() - this.center.getY();
        double zbase = test.getZ() - this.center.getZ();
        return xbase * xbase / (this.size.getX() * this.size.getX()) + ybase * ybase / (this.size.getY() * this.size.getY()) + zbase * zbase / (this.size.getZ() * this.size.getZ()) <= 1.0;
    }

    public boolean intersects(ChunkTag chunk) {
        int xMin = chunk.getX() * 16;
        int zMin = chunk.getZ() * 16;
        LocationTag locTest = chunk.getCenter();
        locTest.setY(this.center.getY());
        if (this.center.getX() > (double)xMin) {
            if (this.center.getX() < (double)(xMin + 16)) {
                locTest.setX(this.center.getX());
            } else {
                locTest.setX(this.center.getX());
            }
        }
        if (this.center.getZ() > (double)zMin) {
            if (this.center.getZ() < (double)(zMin + 16)) {
                locTest.setZ(this.center.getZ());
            } else {
                locTest.setZ(this.center.getZ());
            }
        }
        return this.contains(locTest);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debuggable() {
        if (this.isUnique()) {
            return "<LG>ellipsoid@<Y>" + this.noteName + "<GR> (" + this.identifyFull() + ")";
        }
        return this.identifyFull();
    }

    @Override
    public boolean isUnique() {
        return this.noteName != null;
    }

    @Override
    @Note(value="Ellipsoids")
    public Object getSaveObject() {
        YamlConfiguration section = new YamlConfiguration();
        section.set("object", this.identifyFull());
        section.set("flags", this.flagTracker.toString());
        return section;
    }

    @Override
    public void makeUnique(String id) {
        EllipsoidTag toNote = this.clone();
        toNote.noteName = id;
        toNote.flagTracker = new SavableMapFlagTracker();
        NoteManager.saveAs(toNote, id);
    }

    @Override
    public void forget() {
        NoteManager.remove(this);
        this.noteName = null;
        this.flagTracker = null;
    }

    public int hashCode() {
        if (this.noteName != null) {
            return this.noteName.hashCode();
        }
        return this.center.hashCode() + this.size.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof EllipsoidTag)) {
            return false;
        }
        EllipsoidTag ellipsoid2 = (EllipsoidTag)other;
        if (this.noteName == null != (ellipsoid2.noteName == null)) {
            return false;
        }
        if (this.noteName != null && !this.noteName.equals(ellipsoid2.noteName)) {
            return false;
        }
        if (!this.center.getWorldName().equals(ellipsoid2.center.getWorldName())) {
            return false;
        }
        if (this.center.distanceSquaredNoWorld(ellipsoid2.center) >= 0.25) {
            return false;
        }
        return !(this.size.distanceSquaredNoWorld(ellipsoid2.size) >= 0.25);
    }

    @Override
    public String getObjectType() {
        return "Ellipsoid";
    }

    @Override
    public String identify() {
        if (this.isUnique()) {
            return "ellipsoid@" + this.noteName;
        }
        return this.identifyFull();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String identifyFull() {
        return "ellipsoid@" + this.center.getX() + "," + this.center.getY() + "," + this.center.getZ() + "," + this.center.getWorldName() + "," + this.size.getX() + "," + this.size.getY() + "," + this.size.getZ();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        return this.flagTracker;
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
        if (this.noteName != null) {
            this.flagTracker = tracker;
        }
    }

    @Override
    public String getReasonNotFlaggable() {
        if (this.noteName == null) {
            return "the area is not noted - only noted areas can hold flags";
        }
        return "unknown reason - something went wrong";
    }

    @Override
    public CuboidTag getCuboidBoundary() {
        return new CuboidTag(this.center.clone().subtract(this.size.toVector()), this.center.clone().add(this.size.toVector()));
    }

    @Override
    public WorldTag getWorld() {
        return new WorldTag(this.center.getWorldName());
    }

    @Override
    public EllipsoidTag withWorld(WorldTag world) {
        LocationTag loc = this.center.clone();
        loc.setWorld(world.getWorld());
        return new EllipsoidTag(loc, this.size.clone());
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        AreaContainmentObject.registerTags(EllipsoidTag.class, tagProcessor);
        tagProcessor.registerTag(LocationTag.class, "random", (attribute, object) -> {
            double y = (Math.sqrt(CoreUtilities.getRandom().nextDouble()) * 2.0 - 1.0) * object.size.getY();
            Vector result = new Vector();
            result.setY(y);
            double yProg = Math.abs(y) / object.size.getY();
            double subWidth = Math.sqrt(1.0 - yProg * yProg);
            double maxX = object.size.getX() * subWidth;
            double maxZ = object.size.getZ() * subWidth;
            result.setX(maxX * (CoreUtilities.getRandom().nextDouble() * 2.0 - 1.0));
            result.setZ(maxZ * (CoreUtilities.getRandom().nextDouble() * 2.0 - 1.0));
            LocationTag out = object.center.clone();
            out.add(result);
            return out;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "location", (attribute, object) -> object.center, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "size", (attribute, object) -> object.size, new String[0]);
        tagProcessor.registerTag(EllipsoidTag.class, "add", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("ellipsoid.add[...] tag must have an input.");
                return null;
            }
            return new EllipsoidTag(object.center.clone().add(attribute.paramAsType(LocationTag.class)), object.size.clone());
        }, new String[0]);
        tagProcessor.registerTag(EllipsoidTag.class, "include", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("ellipsoid.include[...] tag must have an input.");
                return null;
            }
            LocationTag target = attribute.paramAsType(LocationTag.class);
            if (object.contains(target)) {
                return object;
            }
            LocationTag size = object.size.clone();
            Vector relative = target.toVector().subtract(object.center.toVector());
            size.setX(Math.max(size.getX(), Math.abs(relative.getX())));
            size.setY(Math.max(size.getY(), Math.abs(relative.getY())));
            size.setZ(Math.max(size.getZ(), Math.abs(relative.getZ())));
            EllipsoidTag result = new EllipsoidTag(object.center.clone(), new LocationTag(size));
            if (result.contains(target)) {
                return result;
            }
            double sizeLen = size.length();
            while (!result.contains(target)) {
                double projX = relative.getX() * relative.getX() / (size.getX() * size.getX());
                double projY = relative.getY() * relative.getY() / (size.getY() * size.getY());
                double projZ = relative.getZ() * relative.getZ() / (size.getZ() * size.getZ());
                double scale = Math.max(projX + projY + projZ, sizeLen * 0.01);
                if (projX >= projY && projX >= projZ) {
                    size.setX(size.getX() + scale);
                } else if (projY >= projX && projY >= projZ) {
                    size.setY(size.getY() + scale);
                } else if (projZ >= projX && projZ >= projY) {
                    size.setZ(size.getZ() + scale);
                } else {
                    size = size.add(scale, scale, scale);
                }
                result.size = size;
            }
            return result;
        }, new String[0]);
        tagProcessor.registerTag(EllipsoidTag.class, "with_location", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("ellipsoid.with_location[...] tag must have an input.");
                return null;
            }
            return new EllipsoidTag(attribute.paramAsType(LocationTag.class), object.size.clone());
        }, new String[0]);
        tagProcessor.registerTag(EllipsoidTag.class, "with_size", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("ellipsoid.with_size[...] tag must have an input.");
                return null;
            }
            return new EllipsoidTag(object.center.clone(), attribute.paramAsType(LocationTag.class));
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "chunks", (attribute, object) -> {
            ListTag chunks = new ListTag();
            double minPossibleX = object.center.getX() - object.size.getX();
            double minPossibleZ = object.center.getZ() - object.size.getZ();
            double maxPossibleX = object.center.getX() + object.size.getX();
            double maxPossibleZ = object.center.getZ() + object.size.getZ();
            int minChunkX = (int)Math.floor(minPossibleX / 16.0);
            int minChunkZ = (int)Math.floor(minPossibleZ / 16.0);
            int maxChunkX = (int)Math.ceil(maxPossibleX / 16.0);
            int maxChunkZ = (int)Math.ceil(maxPossibleZ / 16.0);
            ChunkTag testChunk = new ChunkTag(object.center);
            for (int x = minChunkX; x <= maxChunkX; ++x) {
                testChunk.chunkX = x;
                for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                    testChunk.chunkZ = z;
                    if (!object.intersects(testChunk)) continue;
                    chunks.addObject(new ChunkTag(testChunk.world, testChunk.chunkX, testChunk.chunkZ));
                }
            }
            return chunks;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "note_name", (attribute, ellipsoid) -> {
            String noteName = NoteManager.getSavedId(ellipsoid);
            if (noteName == null) {
                return null;
            }
            return new ElementTag(noteName);
        }, new String[0]);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public String getNoteName() {
        return this.noteName;
    }

    @Override
    public boolean doesContainLocation(Location loc) {
        return this.contains(loc);
    }
}

