/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.VillagerReplenishTradeEvent;

public class VillagerReplenishesTradeScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static VillagerReplenishesTradeScriptEvent instance;
    public EntityTag entity;
    public VillagerReplenishTradeEvent event;

    public VillagerReplenishesTradeScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("villager replenishes trade");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "VillagerReplenishesTrade";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (TradeTag.matches(determinationObj.toString())) {
            this.event.setRecipe(determinationObj.asType(TradeTag.class, this.getTagContext(path)).getRecipe());
            return true;
        }
        if (determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isInt()) {
            this.event.setBonus(((ElementTag)determinationObj).asInt());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.entity;
            }
            case "trade": {
                return new TradeTag(this.event.getRecipe()).duplicate();
            }
            case "bonus": {
                return new ElementTag(this.event.getBonus());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onVillagerReplenishesTrade(VillagerReplenishTradeEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

