/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.ScoreboardHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Iterator;
import org.bukkit.ChatColor;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class TeamCommand
extends AbstractCommand {
    public TeamCommand() {
        this.setName("team");
        this.setSyntax("team (id:<scoreboard>/{main}) [name:<team>] (add:<entry>|...) (remove:<entry>|...) (prefix:<prefix>) (suffix:<suffix>) (option:<type> status:<status>) (color:<color>)");
        this.setRequiredArguments(2, 9);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String name = null;
        String prefix = null;
        String suffix = null;
        for (Argument arg : scriptEntry) {
            if (arg.matchesPrefix("id") && !scriptEntry.hasObject("id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("name") && !scriptEntry.hasObject("name")) {
                ElementTag nameElement = arg.asElement();
                name = nameElement.asString();
                scriptEntry.addObject("name", nameElement);
                continue;
            }
            if (arg.matchesPrefix("add") && !scriptEntry.hasObject("add")) {
                scriptEntry.addObject("add", arg.asType(ListTag.class));
                continue;
            }
            if (arg.matchesPrefix("remove") && !scriptEntry.hasObject("remove")) {
                scriptEntry.addObject("remove", arg.asType(ListTag.class));
                continue;
            }
            if (arg.matchesPrefix("prefix") && !scriptEntry.hasObject("prefix")) {
                ElementTag prefixElement = arg.asElement();
                prefix = prefixElement.asString();
                scriptEntry.addObject("prefix", prefixElement);
                continue;
            }
            if (arg.matchesPrefix("suffix") && !scriptEntry.hasObject("suffix")) {
                ElementTag suffixElement = arg.asElement();
                suffix = suffixElement.asString();
                scriptEntry.addObject("suffix", suffixElement);
                continue;
            }
            if (arg.matchesPrefix("color") && arg.matchesEnum((Enum<?>[])ChatColor.values()) && !scriptEntry.hasObject("color")) {
                scriptEntry.addObject("color", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("option") && !scriptEntry.hasObject("option") && (arg.matchesEnum((Enum<?>[])Team.Option.values()) || arg.matches("friendly_fire", "see_invisible"))) {
                scriptEntry.addObject("option", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("status") && !scriptEntry.hasObject("status") && arg.matchesEnum((Enum<?>[])Team.OptionStatus.values())) {
                scriptEntry.addObject("status", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (name == null || name.length() == 0 || name.length() > 16) {
            throw new InvalidArgumentsException("Must specify a team name between 1 and 16 characters!");
        }
        if (!(scriptEntry.hasObject("add") || scriptEntry.hasObject("remove") || scriptEntry.hasObject("option") || scriptEntry.hasObject("color") || scriptEntry.hasObject("prefix") || scriptEntry.hasObject("suffix"))) {
            throw new InvalidArgumentsException("Must specify something to do with the team!");
        }
        if (prefix != null && prefix.length() > 64 || suffix != null && suffix.length() > 64) {
            throw new InvalidArgumentsException("Prefixes and suffixes must be 64 characters or less!");
        }
        if (scriptEntry.hasObject("option") != scriptEntry.hasObject("status")) {
            throw new InvalidArgumentsException("Option and Status arguments must go together!");
        }
        scriptEntry.defaultObject("id", new ElementTag("main"));
    }

    public static String translateEntry(String entry, TagContext context) {
        EntityTag entity;
        if (entry.startsWith("p@")) {
            PlayerTag player = PlayerTag.valueOf(entry, context);
            if (player != null) {
                return player.getName();
            }
        } else if (entry.startsWith("e@") && (entity = EntityTag.valueOf(entry, context)) != null) {
            return entity.getUUID().toString();
        }
        return entry;
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Scoreboard board;
        Team team;
        ElementTag id = scriptEntry.getElement("id");
        ElementTag name = scriptEntry.getElement("name");
        ListTag add = (ListTag)scriptEntry.getObjectTag("add");
        ListTag remove = (ListTag)scriptEntry.getObjectTag("remove");
        ElementTag prefix = scriptEntry.getElement("prefix");
        ElementTag suffix = scriptEntry.getElement("suffix");
        ElementTag option = scriptEntry.getElement("option");
        ElementTag status = scriptEntry.getElement("status");
        ElementTag color = scriptEntry.getElement("color");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), id, name, add, remove, prefix, suffix, color, option, status);
        }
        if ((team = (board = id.asString().equalsIgnoreCase("main") ? ScoreboardHelper.getMain() : (ScoreboardHelper.hasScoreboard(id.asString()) ? ScoreboardHelper.getScoreboard(id.asString()) : ScoreboardHelper.createScoreboard(id.asString()))).getTeam(name.asString())) == null) {
            Iterator<String> low = CoreUtilities.toLowerCase(name.asString());
            team = board.getTeams().stream().filter(t -> CoreUtilities.toLowerCase(t.getName()).equals(low)).findFirst().orElse(null);
            if (team == null) {
                team = board.registerNewTeam(name.asString());
            }
        }
        if (add != null) {
            for (String string : add) {
                if (team.hasEntry(string = TeamCommand.translateEntry(string, scriptEntry.context))) continue;
                team.addEntry(string);
            }
        }
        if (remove != null) {
            for (String string : remove) {
                if (!team.hasEntry(string = TeamCommand.translateEntry(string, scriptEntry.context))) continue;
                team.removeEntry(string);
            }
        }
        if (option != null) {
            String optName = CoreUtilities.toLowerCase(option.asString());
            String statusName = CoreUtilities.toLowerCase(status.asString());
            if (optName.equals("friendly_fire")) {
                team.setAllowFriendlyFire(statusName.equals("always"));
            } else if (optName.equals("see_invisible")) {
                team.setCanSeeFriendlyInvisibles(statusName.equals("always"));
            } else {
                team.setOption(Team.Option.valueOf((String)optName.toUpperCase()), Team.OptionStatus.valueOf((String)statusName.toUpperCase()));
            }
        }
        if (prefix != null) {
            team.setPrefix(prefix.asString());
        }
        if (suffix != null) {
            team.setSuffix(suffix.asString());
        }
        if (color != null) {
            team.setColor(ChatColor.valueOf((String)color.asString().toUpperCase()));
        }
        if (team.getEntries().isEmpty()) {
            team.unregister();
        }
    }
}

