/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashSet;

public class DebugCommand
extends AbstractCommand
implements Holdable {
    public static HashSet<String> DBINFO = Argument.precalcEnum(DebugType.values());

    public DebugCommand() {
        this.setName("debug");
        this.setSyntax("debug [<type>] [<message>] (name:<name>)");
        this.setRequiredArguments(2, 3);
        this.isProcedural = true;
        this.setPrefixesHandled("name");
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.add(DebugType.values());
        tab.add("start", "submit", "cancel");
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("type") && arg.limitToOnlyPrefix("type") && arg.matchesEnum(DBINFO)) {
                scriptEntry.addObject("type", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("debug")) {
                scriptEntry.addObject("debug", arg.getRawElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("type") || !scriptEntry.hasObject("debug")) {
            throw new InvalidArgumentsException("Must specify a debug type and message!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag debug = scriptEntry.getElement("debug");
        ElementTag type = scriptEntry.getElement("type");
        ElementTag name = scriptEntry.argForPrefixAsElement("name", "name");
        DebugType dbType = DebugType.valueOf(type.asString().toUpperCase());
        if (dbType != DebugType.RECORD) {
            scriptEntry.setFinished(true);
        }
        block0 : switch (dbType) {
            case DEBUG: {
                Debug.echoDebug((Debuggable)scriptEntry, debug.asString());
                break;
            }
            case HEADER: {
                Debug.echoDebug(scriptEntry, Debug.DebugElement.Header, debug.asString());
                break;
            }
            case FOOTER: {
                Debug.echoDebug(scriptEntry, Debug.DebugElement.Footer, debug.asString());
                break;
            }
            case SPACER: {
                Debug.echoDebug(scriptEntry, Debug.DebugElement.Spacer, debug.asString());
                break;
            }
            case LOG: {
                Debug.log(debug.asString());
                break;
            }
            case APPROVAL: {
                Debug.echoApproval(debug.asString());
                break;
            }
            case ERROR: {
                Debug.echoError(scriptEntry, debug.asString());
                break;
            }
            case REPORT: {
                if (!scriptEntry.dbCallShouldDebug()) break;
                Debug.report((Debuggable)scriptEntry, name.asString(), debug.asString());
                break;
            }
            case EXCEPTION: {
                Debug.echoError(scriptEntry, new RuntimeException(debug.asString()));
                break;
            }
            case RECORD: {
                String form;
                switch (form = CoreUtilities.toLowerCase(debug.asString())) {
                    case "start": {
                        Debug.echoDebug((Debuggable)scriptEntry, "Starting debug recording...");
                        DenizenCore.implementation.startRecording();
                        scriptEntry.setFinished(true);
                        break block0;
                    }
                    case "cancel": {
                        Debug.echoDebug((Debuggable)scriptEntry, "Stopping debug recording...");
                        DenizenCore.implementation.stopRecording();
                        scriptEntry.setFinished(true);
                        break block0;
                    }
                    case "submit": {
                        DenizenCore.implementation.submitRecording(s -> {
                            if (s == null) {
                                Debug.echoDebug((Debuggable)scriptEntry, "Submit failed.");
                            } else if (s.equals("disabled")) {
                                Debug.echoDebug((Debuggable)scriptEntry, "Submit failed: not recording");
                            } else {
                                Debug.echoDebug((Debuggable)scriptEntry, "Submitted to " + s);
                                scriptEntry.addObject("submitted", new ElementTag((String)s));
                            }
                            scriptEntry.setFinished(true);
                        });
                        break block0;
                    }
                }
                Debug.echoError("Debug 'record' command failed: unknown record form '" + form + "'");
                scriptEntry.setFinished(true);
            }
        }
    }

    public static enum DebugType {
        DEBUG,
        HEADER,
        FOOTER,
        SPACER,
        LOG,
        APPROVAL,
        ERROR,
        REPORT,
        EXCEPTION,
        RECORD;

    }
}

