/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.containers.core.TaskScriptContainer;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;

public class InjectCommand
extends AbstractCommand {
    public InjectCommand() {
        this.setName("inject");
        this.setSyntax("inject [<script>] (path:<name>) (instantly)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = true;
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addScriptsOfType(TaskScriptContainer.class);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (arg.matches("instant", "instantly")) {
                scriptEntry.addObject("instant", new ElementTag(true));
                continue;
            }
            if (arg.matches("local", "locally")) {
                Deprecations.locallyArgument.warn(scriptEntry);
                scriptEntry.addObject("script", scriptEntry.getScript());
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(ScriptTag.class) && arg.limitToOnlyPrefix("script")) {
                scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("script") && !scriptEntry.hasObject("path") && !arg.hasPrefix() && arg.asElement().asString().contains(".")) {
                int dotIndex;
                String path = arg.asElement().asString();
                ScriptTag script = new ScriptTag(path.substring(0, dotIndex = path.indexOf(46)));
                if (!script.isValid()) {
                    arg.reportUnhandled();
                    continue;
                }
                scriptEntry.addObject("script", script);
                scriptEntry.addObject("path", new ElementTag(path.substring(dotIndex + 1)));
                continue;
            }
            if (!scriptEntry.hasObject("path") && arg.limitToOnlyPrefix("path")) {
                if (!arg.hasPrefix() && scriptEntry.hasObject("script")) {
                    Debug.echoError("Inject command path is missing required 'path:' prefix.");
                }
                scriptEntry.addObject("path", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("script")) {
            throw new InvalidArgumentsException("Must define a SCRIPT to be injected.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List<ScriptEntry> entries;
        ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        if (script == null) {
            script = scriptEntry.getScript();
        }
        ElementTag instant = scriptEntry.getElement("instant");
        ElementTag path = scriptEntry.getElement("path");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), script, instant, path);
        }
        if ((entries = path != null ? script.getContainer().getEntries(scriptEntry.entryData.clone(), path.asString()) : script.getContainer().getBaseEntries(scriptEntry.entryData.clone())) == null) {
            Debug.echoError(scriptEntry, "Script inject failed (invalid script path '" + path + "')!");
            return;
        }
        if (instant != null && instant.asBoolean()) {
            scriptEntry.getResidingQueue().runNow(entries);
        } else {
            scriptEntry.getResidingQueue().injectEntriesAtStart(entries);
        }
    }
}

