/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBlockMaterial
implements Property {
    public static final String[] handledTags = new String[]{"block_material"};
    public static final String[] handledMechs = new String[]{"block_material"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getItemMeta() instanceof BlockDataMeta;
    }

    public static ItemBlockMaterial getFrom(ObjectTag _item) {
        if (!ItemBlockMaterial.describes(_item)) {
            return null;
        }
        return new ItemBlockMaterial((ItemTag)_item);
    }

    private ItemBlockMaterial(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        BlockDataMeta meta;
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("block_material") && (meta = (BlockDataMeta)this.item.getItemMeta()).hasBlockData()) {
            return new MaterialTag(meta.getBlockData(this.item.getBukkitMaterial())).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        BlockDataMeta meta = (BlockDataMeta)this.item.getItemMeta();
        if (meta.hasBlockData()) {
            return new MaterialTag(meta.getBlockData(this.item.getBukkitMaterial())).identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "block_material";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("block_material") && mechanism.requireObject(MaterialTag.class)) {
            BlockDataMeta meta = (BlockDataMeta)this.item.getItemMeta();
            MaterialTag mat = mechanism.valueAsType(MaterialTag.class);
            meta.setBlockData(mat.getModernData());
            this.item.setItemMeta((ItemMeta)meta);
        }
    }
}

