/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.type.Gate;
import org.bukkit.block.data.type.Lantern;

public class MaterialAttachedToWall
implements Property {
    public static final String[] handledMechs = new String[]{"attached_to_wall"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && (((MaterialTag)material).getModernData() instanceof Gate || ((MaterialTag)material).getModernData() instanceof Lantern);
    }

    public static MaterialAttachedToWall getFrom(ObjectTag _material) {
        if (!MaterialAttachedToWall.describes(_material)) {
            return null;
        }
        return new MaterialAttachedToWall((MaterialTag)_material);
    }

    private MaterialAttachedToWall(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerStaticTag(ElementTag.class, "attached_to_wall", (attribute, material) -> {
            if (material.isGate()) {
                return new ElementTag(material.getGate().isInWall());
            }
            if (material.isLantern()) {
                return new ElementTag(material.getLantern().isHanging());
            }
            return null;
        }, new String[0]);
    }

    public boolean isGate() {
        return this.material.getModernData() instanceof Gate;
    }

    public boolean isLantern() {
        return this.material.getModernData() instanceof Lantern;
    }

    public Gate getGate() {
        return (Gate)this.material.getModernData();
    }

    public Lantern getLantern() {
        return (Lantern)this.material.getModernData();
    }

    public boolean getAttachment() {
        if (this.isGate()) {
            return this.getGate().isInWall();
        }
        if (this.isLantern()) {
            return this.getLantern().isHanging();
        }
        return false;
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getAttachment());
    }

    @Override
    public String getPropertyId() {
        return "attached_to_wall";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("attached_to_wall") && mechanism.requireBoolean()) {
            if (this.isGate()) {
                this.getGate().setInWall(mechanism.getValue().asBoolean());
            } else if (this.isLantern()) {
                this.getLantern().setHanging(mechanism.getValue().asBoolean());
            }
        }
    }
}

