/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class QueueCommand
extends AbstractCommand {
    public QueueCommand() {
        this.setName("queue");
        this.setSyntax("queue (<queue>) [clear/stop/pause/resume/delay:<duration>]");
        this.setRequiredArguments(1, 2);
        this.isProcedural = true;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.class)) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                if (scriptEntry.getObject("action") != Action.DELAY || !arg.matchesArgumentType(DurationTag.class)) continue;
                scriptEntry.addObject("delay", arg.asType(DurationTag.class));
                continue;
            }
            if ((arg.matchesArgumentType(QueueTag.class) || arg.matchesPrefix("queue")) && !scriptEntry.hasObject("queue")) {
                scriptEntry.addObject("queue", arg.asType(QueueTag.class));
                continue;
            }
            throw new InvalidArgumentsException("The specified queue could not be found: " + arg.getRawValue());
        }
        scriptEntry.defaultObject("queue", new QueueTag(scriptEntry.getResidingQueue()));
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an action. Valid: CLEAR, DELAY, PAUSE, RESUME");
        }
        if (scriptEntry.getObject("action") == Action.DELAY && !scriptEntry.hasObject("delay")) {
            throw new InvalidArgumentsException("Must specify a delay.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        QueueTag queue = (QueueTag)scriptEntry.getObjectTag("queue");
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        DurationTag delay = (DurationTag)scriptEntry.getObjectTag("delay");
        if (scriptEntry.getResidingQueue().procedural && !queue.getQueue().id.equals(scriptEntry.getResidingQueue().id)) {
            Debug.echoError("Cannot modify other queues from a procedural queue.");
            return;
        }
        if (queue.getQueue().id.equals(scriptEntry.getResidingQueue().id) && (action == Action.CLEAR || action == Action.STOP)) {
            Deprecations.queueClear.warn(scriptEntry);
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), queue, QueueCommand.db("Action", (Object)action), delay);
        }
        switch (action) {
            case CLEAR: {
                queue.queue.clear();
                return;
            }
            case STOP: {
                queue.queue.clear();
                queue.queue.stop();
                return;
            }
            case PAUSE: {
                if (queue.queue instanceof TimedQueue) {
                    ((TimedQueue)queue.queue).setPaused(true);
                } else {
                    queue.queue.forceToTimed(new TimedQueue.DeltaTimeDelayTracker(1L)).setPaused(true);
                }
                return;
            }
            case RESUME: {
                if (queue.queue instanceof TimedQueue) {
                    ((TimedQueue)queue.queue).setPaused(false);
                }
                return;
            }
            case DELAY: {
                if (queue.queue instanceof TimedQueue) {
                    ((TimedQueue)queue.queue).delayFor(delay);
                } else {
                    queue.queue.forceToTimed(new TimedQueue.DeltaTimeDelayTracker(delay.getMillis()));
                }
                return;
            }
        }
    }

    private static enum Action {
        CLEAR,
        DELAY,
        PAUSE,
        RESUME,
        STOP;

    }
}

