/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.scripts.commands.entity.RenameCommand;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import java.util.UUID;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;

public class MirrorNameTrait
extends Trait {
    @Persist(value="")
    public boolean mirror = true;
    public UUID mirroredUUID = null;

    public MirrorNameTrait() {
        super("mirrorname");
    }

    public void respawn() {
        if (!this.npc.isSpawned() || this.npc.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), () -> {
            if (this.npc.isSpawned()) {
                Location loc = this.npc.getStoredLocation().clone();
                this.npc.despawn(DespawnReason.PENDING_RESPAWN);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), () -> this.npc.spawn(loc));
            }
        });
    }

    public void mirrorOn() {
        NetworkInterceptHelper.enable();
        if (!this.npc.isSpawned()) {
            return;
        }
        this.mirroredUUID = this.npc.getEntity().getUniqueId();
        RenameCommand.RenameData renamer = new RenameCommand.RenameData();
        renamer.nameFunction = OfflinePlayer::getName;
        RenameCommand.addDynamicRename(this.npc.getEntity(), null, renamer);
    }

    public void mirrorOff() {
        if (this.mirroredUUID == null) {
            return;
        }
        if (RenameCommand.customNames.remove(this.mirroredUUID) != null && this.npc.isSpawned() && this.npc.getEntity().getType() == EntityType.PLAYER) {
            this.respawn();
        }
    }

    public void enableMirror() {
        this.mirror = true;
        this.mirrorOn();
        if (this.npc.isSpawned() && this.npc.getEntity().getType() == EntityType.PLAYER) {
            this.respawn();
        }
    }

    public void disableMirror() {
        this.mirror = false;
        this.mirrorOff();
    }

    public void onSpawn() {
        if (this.mirror) {
            this.mirrorOn();
        }
    }

    public void onRemove() {
        if (this.mirror) {
            this.mirrorOff();
        }
    }

    public void onAttach() {
        if (this.mirror) {
            this.mirrorOn();
        }
    }
}

